/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.viewers;

import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class VirtualSphere {
    public Transform3D t3d = null;
    private Matrix4d rMat = null;
    private Vector3d op = null;
    private Vector3d oq = null;
    private Vector3d a = null;
    private int cueCenterX = 320;
    private int cueCenterY = 240;
    private int cueRadius = 200;

    public VirtualSphere() {
        this.VirtualSphereInit(this.cueCenterX, this.cueCenterY, this.cueRadius);
    }

    public VirtualSphere(int n, int n2, int n3) {
        this.VirtualSphereInit(n, n2, n3);
    }

    public void VirtualSphereInit(int n, int n2, int n3) {
        this.t3d = new Transform3D();
        this.rMat = new Matrix4d();
        this.op = new Vector3d();
        this.oq = new Vector3d();
        this.a = new Vector3d();
        this.setCircle(n, n2, n3);
    }

    public void setCircle(int n, int n2, int n3) {
        this.cueCenterX = n;
        this.cueCenterY = n2;
        this.cueRadius = n3;
    }

    public void compute(int n, int n2, int n3, int n4) {
        this.PointOnUnitSphere(n, n2, this.op);
        this.PointOnUnitSphere(n3, n4, this.oq);
        double d = this.a.x;
        double d2 = this.a.y;
        double d3 = this.a.z;
        double d4 = d * d;
        double d5 = d2 * d2;
        double d6 = d3 * d3;
        this.a.cross(this.op, this.oq);
        double d7 = this.a.length();
        double d8 = this.op.dot(this.oq);
        double d9 = 1.0 - d8;
        if (d7 > 0.0) {
            this.a.x /= d7;
            this.a.y /= d7;
            this.a.z /= d7;
        }
        this.rMat.m00 = d9 * d4 + d8;
        this.rMat.m01 = d9 * d * d2 + d7 * d3;
        this.rMat.m02 = d9 * d * d3 - d7 * d2;
        this.rMat.m10 = d9 * d * d2 - d7 * d3;
        this.rMat.m11 = d9 * d5 + d8;
        this.rMat.m12 = d9 * d2 * d3 + d7 * d;
        this.rMat.m20 = d9 * d * d3 + d7 * d2;
        this.rMat.m21 = d9 * d2 * d3 - d7 * d;
        this.rMat.m22 = d9 * d6 + d8;
        this.rMat.m32 = 0.0;
        this.rMat.m31 = 0.0;
        this.rMat.m30 = 0.0;
        this.rMat.m23 = 0.0;
        this.rMat.m13 = 0.0;
        this.rMat.m03 = 0.0;
        this.rMat.m33 = 1.0;
        this.t3d.set(this.rMat);
        this.t3d.setScale(this.t3d.getScale());
        this.t3d.normalize();
    }

    public void PointOnUnitSphere(int n, int n2, Vector3d vector3d) {
        vector3d.x = (double)(n - this.cueCenterX) / (double)this.cueRadius;
        vector3d.y = (double)(-(n2 - this.cueCenterY)) / (double)this.cueRadius;
        double d = vector3d.x * vector3d.x + vector3d.y * vector3d.y;
        if (d < 1.0) {
            vector3d.z = Math.sqrt(1.0 - d);
        } else {
            double d2 = Math.sqrt(d);
            vector3d.x /= d2;
            vector3d.y /= d2;
            vector3d.z = 0.0;
        }
    }
}

