/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.viewers;

import edu.sdsc.vis.viewers.ViewerBehavior;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Vector3d;

public class WalkViewerBehavior
extends ViewerBehavior {
    protected int previousX = 0;
    protected int previousY = 0;
    protected int initialX = 0;
    protected int initialY = 0;
    protected int x = 0;
    protected int y = 0;
    protected static final int DELTAX_DEADZONE = 10;
    protected static final int DELTAY_DEADZONE = 10;
    protected WakeupCriterion[] mouseAndAnimationEvents = null;
    protected WakeupOr mouseAndAnimationCriterion = null;
    protected WakeupOr savedWakeupCriterion = null;
    protected Cursor savedCursor = null;
    Vector3d zeroVector = new Vector3d(0.0, 0.0, 0.0);
    public static final double DEFAULT_YROTATION_ANIMATION_FACTOR = 2.0E-4;
    public static final double DEFAULT_ZTRANSLATION_ANIMATION_FACTOR = 0.01;
    protected double YRotationAnimationFactor = 2.0E-4;
    protected double ZTranslationAnimationFactor = 0.01;
    private int key_nav_rate = 120;

    public WalkViewerBehavior() {
    }

    public WalkViewerBehavior(Component component) {
        super(component);
    }

    public WalkViewerBehavior(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public WalkViewerBehavior(TransformGroup transformGroup, Component component) {
        super(component);
        this.subjectTransformGroup = transformGroup;
    }

    public void initialize() {
        super.initialize();
        this.savedWakeupCriterion = this.wakeupConditions;
        this.mouseAndAnimationEvents = new WakeupCriterion[4];
        this.mouseAndAnimationEvents[0] = new WakeupOnAWTEvent(506);
        this.mouseAndAnimationEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseAndAnimationEvents[2] = new WakeupOnAWTEvent(502);
        this.mouseAndAnimationEvents[3] = new WakeupOnElapsedFrames(0);
        this.mouseAndAnimationCriterion = new WakeupOr(this.mouseAndAnimationEvents);
    }

    public void setYRotationAnimationFactor(double d) {
        this.YRotationAnimationFactor = d;
    }

    public double getYRotationAnimationFactor() {
        return this.YRotationAnimationFactor;
    }

    public void setZTranslationAnimationFactor(double d) {
        this.ZTranslationAnimationFactor = d;
    }

    public double getZTranslationAnimationFactor() {
        return this.ZTranslationAnimationFactor;
    }

    public void onElapsedFrames(WakeupOnElapsedFrames wakeupOnElapsedFrames) {
        if (this.buttonPressed != 0) {
            return;
        }
        int n = this.previousX - this.initialX;
        int n2 = this.previousY - this.initialY;
        double d = (double)(-n) * this.YRotationAnimationFactor;
        double d2 = (double)n2 * this.ZTranslationAnimationFactor;
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.get(this.matrix);
        this.translate.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
        this.currentTransform.setTranslation(this.origin);
        this.transform3.rotY(-d);
        this.transform1.set(this.currentTransform);
        this.transform1.setTranslation(this.zeroVector);
        this.transform2.set(this.transform1);
        this.transform3.invert();
        this.transform2.mul(this.transform3);
        this.transform1.invert();
        this.transform2.mul(this.transform1);
        this.transform2.mul(this.currentTransform);
        this.currentTransform.set(this.transform2);
        this.currentTransform.setTranslation(this.translate);
        this.translate.set(0.0, 0.0, -d2);
        this.transform3.set(this.translate);
        this.transform1.set(this.currentTransform);
        this.transform1.setTranslation(this.zeroVector);
        this.transform2.set(this.transform1);
        this.transform3.invert();
        this.transform2.mul(this.transform3);
        this.transform1.invert();
        this.transform2.mul(this.transform1);
        this.transform2.mul(this.currentTransform);
        this.currentTransform.set(this.transform2);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.fireTransform(this.currentTransform);
    }

    public void onButton1(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = this.x;
            this.previousY = this.y;
            this.initialX = this.x;
            this.initialY = this.y;
            this.wakeupConditions = this.mouseAndAnimationCriterion;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(12));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            this.wakeupConditions = this.savedWakeupCriterion;
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        this.previousX = this.x;
        this.previousY = this.y;
        this.fireTransform(this.currentTransform);
    }

    public void onButton2(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = this.x;
            this.previousY = this.y;
            this.initialX = this.x;
            this.initialY = this.y;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int n = this.x - this.previousX;
        int n2 = 0;
        if (Math.abs(this.y - this.initialY) > 10) {
            n2 = this.y - this.previousY;
        }
        if (n > 400 || n < -400 || n2 > 400 || n2 < -400) {
            return;
        }
        double d = (double)(-n2) * this.XRotationFactor;
        double d2 = (double)(-n) * this.YRotationFactor;
        this.transform1.rotX(d);
        this.transform2.rotY(d2);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.get(this.matrix);
        this.translate.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
        this.currentTransform.setTranslation(this.origin);
        this.currentTransform.mul(this.transform2, this.currentTransform);
        this.currentTransform.mul(this.transform1);
        this.currentTransform.setTranslation(this.translate);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = this.x;
        this.previousY = this.y;
        this.fireTransform(this.currentTransform);
    }

    public void onButton3(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = this.x;
            this.previousY = this.y;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int n = this.x - this.previousX;
        int n2 = this.y - this.previousY;
        if (n > 400 || n < -400 || n2 > 400 || n2 < -400) {
            return;
        }
        double d = (double)n * this.XTranslationFactor;
        double d2 = (double)(-n2) * this.YTranslationFactor;
        this.translate.set(d, d2, 0.0);
        this.transform1.set(this.translate);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.mul(this.transform1);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = this.x;
        this.previousY = this.y;
        this.fireTransform(this.currentTransform);
    }
}

