/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.openmms.cifparse;

import java.io.IOException;
import java.util.ArrayList;
import org.rcsb.openmms.cifparse.Builder;
import org.rcsb.openmms.cifparse.CifDictionary;
import org.rcsb.openmms.cifparse.CifParseException;
import org.rcsb.openmms.cifparse.CifTokenizer;
import org.rcsb.openmms.cifparse.DataItem;
import org.rcsb.openmms.cifparse.DataItemList;
import org.rcsb.openmms.cifparse.DictionaryCategory;
import org.rcsb.openmms.cifparse.DictionaryItem;

public class CifParser {
    DictionaryItem di = null;
    DictionaryCategory dcat = null;
    Builder buildr;
    static final int SAVE_CLOSED = 1;
    static final int SAVE_CATEGORY = 2;
    static final int SAVE_ITEM = 3;
    static final int LOOP_CLOSED = 1;
    static final int LOOP_READING_ITEM_LIST = 2;
    static final int LOOP_READING_VALUES = 3;

    public void setBuilder(Builder builder) {
        this.buildr = builder;
    }

    public Builder getBuilder() {
        return this.buildr;
    }

    public void readDictionary(CifTokenizer cifTokenizer, CifDictionary cifDictionary, boolean bl) throws CifParseException {
        try {
            String string;
            String string2 = null;
            int n = 1;
            int n2 = 1;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = cifTokenizer.getToken()) != null) {
                if (string.startsWith("save_")) {
                    if (n2 == 1) {
                        String string3 = string.substring(5);
                        n2 = this.startNewSaveBlock(cifTokenizer, string3, cifDictionary, bl);
                        continue;
                    }
                    if (n == 2) {
                        throw new CifParseException("readDictionary: No data inside 'save_' block");
                    }
                    if (n == 3) {
                        if (n4 != 0) {
                            throw new CifParseException("readDictionary: end of 'save_' block unexpected\n\tItem number: " + n4 + " of " + n3 + "\n\t<Token>= " + string + "<Next Token>= " + cifTokenizer.getToken());
                        }
                        n = 1;
                        n3 = 0;
                    }
                    n2 = 1;
                    continue;
                }
                if (n2 == true) continue;
                if (string.compareTo("loop_") == 0) {
                    if (n == 1) {
                        n = 2;
                        n4 = 0;
                        n3 = 0;
                        arrayList.clear();
                        continue;
                    }
                    if (n == 2) {
                        throw new CifParseException("readDictionary: loop contains no values");
                    }
                    if (n == 3) {
                        if (n4 != 0) {
                            throw new CifParseException("readDictionary: incomplete value inside loop\n\tItem number: " + n4 + " of " + n3 + "\n\t<Token>= " + string + "<Next Token>= " + cifTokenizer.getToken());
                        }
                        n = 2;
                        n3 = 0;
                        arrayList.clear();
                        continue;
                    }
                }
                if (n == 2) {
                    if (cifTokenizer.tokenIsName) {
                        arrayList.add(string);
                        ++n3;
                    } else {
                        n = 3;
                    }
                }
                if (n == 3) {
                    if (cifTokenizer.tokenIsName) {
                        if (n4 != 0) {
                            throw new CifParseException("readDictionary: Name found where value expected, inside 'loop_'\n\tItem number: " + n4 + " of " + n3 + "\n\t<Token>= " + string + "<Next Token>= " + cifTokenizer.getToken());
                        }
                        n = 1;
                        n3 = 0;
                        arrayList.clear();
                    } else {
                        if (n3 == 0) {
                            throw new CifParseException("readDictionary: No Item List inside loop\n\tItem number: " + n4 + " of " + n3 + "\n\t<Token>= " + string + "<Next Token>= " + cifTokenizer.getToken());
                        }
                        if (n2 == 3 && ((String)arrayList.get(n4)).compareTo("_item.name") == 0 && string.equals(this.di.getItemName())) {
                            bl2 = true;
                        }
                        if (bl2 && ((String)arrayList.get(n4)).compareTo("_item.mandatory_code") == 0) {
                            if (this.di != null) {
                                this.di.setItemMandatoryCode(string);
                            }
                        } else if (bl2 && ((String)arrayList.get(n4)).compareTo("_item_type.code") == 0) {
                            if (this.di != null) {
                                this.di.setItemType(string);
                            }
                        } else if (bl2 && ((String)arrayList.get(n4)).compareTo("_item_default.value") == 0) {
                            if (this.di != null) {
                                this.di.setItemDefaultValue(string);
                            }
                        } else if (((String)arrayList.get(n4)).compareTo("_item_linked.child_name") == 0) {
                            if (string2 != null) {
                                throw new CifParseException("readDictionary: parent/child fault");
                            }
                            string2 = string;
                        } else if (((String)arrayList.get(n4)).compareTo("_item_linked.parent_name") == 0) {
                            if (string2 != null) {
                                cifDictionary.setParent(string2, string);
                                string2 = null;
                            } else {
                                throw new CifParseException("readDictionary: no child index");
                            }
                        }
                        if (++n4 == n3) {
                            n4 = 0;
                            bl2 = false;
                        }
                    }
                }
                if (n != 1) continue;
                if (n2 == 2 && string.compareTo("_category.description") == 0) {
                    string = cifTokenizer.getToken();
                    if (this.dcat == null) continue;
                    this.dcat.setCategoryDescription(string);
                    continue;
                }
                if (n2 == 2 && string.compareTo("_category.mandatory_code") == 0) {
                    string = cifTokenizer.getToken();
                    if (this.dcat == null) continue;
                    this.dcat.setCategoryMandatoryCode(string);
                    continue;
                }
                if (n2 == 3 && string.compareTo("_item.name") == 0) {
                    string = cifTokenizer.getToken();
                    if (string == null || string.equalsIgnoreCase(this.di.getItemName())) continue;
                    throw new CifParseException("_item.name does not match _save name\n\t_item.name= " + string + "\n\t_save name= " + this.di.getItemName());
                }
                if (n2 == 3 && string.compareTo("_item.mandatory_code") == 0) {
                    string = cifTokenizer.getToken();
                    if (this.di == null) continue;
                    this.di.setItemMandatoryCode(string);
                    continue;
                }
                if (n2 == 3 && string.compareTo("_item_type.code") == 0) {
                    string = cifTokenizer.getToken();
                    if (this.di == null) continue;
                    this.di.setItemType(string);
                    continue;
                }
                if (n2 == 3 && string.compareTo("_item_default.value") == 0) {
                    string = cifTokenizer.getToken();
                    if (this.di == null) continue;
                    this.di.setItemDefaultValue(string);
                    continue;
                }
                if (n2 != 3 || string.compareTo("_item_description.description") != 0) continue;
                string = cifTokenizer.getToken();
                if (this.di == null) continue;
                this.di.setItemDescription(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            System.exit(1);
        }
    }

    public int startNewSaveBlock(CifTokenizer cifTokenizer, String string, CifDictionary cifDictionary, boolean bl) throws CifParseException, IOException {
        int n;
        block14: {
            String string2;
            n = 1;
            boolean bl2 = string.equals(string.toUpperCase());
            if (string == null || string.length() == 0) {
                throw new CifParseException("startNewSaveBlock: no block name");
            }
            if (bl2) {
                if (bl) {
                    if (cifDictionary.getDictionaryCategoryList().isAlreadyDefined(string)) {
                        this.dcat = null;
                    } else {
                        this.dcat = new DictionaryCategory(string);
                        cifDictionary.getDictionaryCategoryList().add(this.dcat);
                    }
                } else {
                    this.dcat = cifDictionary.getDictionaryCategoryList().findDictionaryCategory(string);
                }
                if (this.dcat != null) {
                    n = 2;
                    this.dcat.definitionFound = true;
                }
            } else {
                if (bl) {
                    if (cifDictionary.getDictionaryItemList().isAlreadyDefined(string)) {
                        this.di = null;
                    } else {
                        this.di = new DictionaryItem(string);
                        cifDictionary.getDictionaryItemList().add(this.di);
                    }
                } else {
                    this.di = cifDictionary.getDictionaryItemList().findDictionaryItem(string);
                }
                if (this.di != null) {
                    n = 3;
                    this.di.definitionFound = true;
                }
            }
            if (n != 1) break block14;
            while ((string2 = cifTokenizer.getToken()) != null && !string2.startsWith("save_")) {
            }
        }
        return n;
    }

    public void readDataBlock(CifTokenizer cifTokenizer, DataItemList dataItemList) throws CifParseException {
        DataItemList dataItemList2 = new DataItemList();
        try {
            boolean bl = false;
            boolean bl2 = false;
            if (this.buildr == null) {
                throw new CifParseException("readDataBlock: No Builder Installed");
            }
            int n = 1;
            DataItem dataItem = null;
            DataItem dataItem2 = null;
            int n2 = 0;
            int n3 = 0;
            this.buildr.beginCompound();
            while (true) {
                String string;
                if ((string = cifTokenizer.getToken()) == null) {
                    if (n == 2) {
                        throw new CifParseException("readDataBlock: premature EOF inside loop" + this.itemErrorMsg(n2, dataItem));
                    }
                    if (n == 3) {
                        if (n3 != 0) {
                            throw new CifParseException("readDataBlock: EOF found while reading values" + this.itemErrorMsg(n2, dataItem));
                        }
                        n = 1;
                        this.buildr.endLoop();
                    }
                    break;
                }
                if (string.startsWith("data_")) continue;
                if (string.compareTo("loop_") == 0) {
                    if (bl) {
                        throw new CifParseException("readDataBlock: 'loop_' statement inside item definition");
                    }
                    if (n == 1) {
                        n = 2;
                        n3 = 0;
                        n2 = 0;
                        dataItemList2.clear();
                        continue;
                    }
                    if (n == 2) {
                        throw new CifParseException("readDataBlock: loop contains no values" + this.itemErrorMsg(n2, dataItem));
                    }
                    if (n == 3) {
                        if (n3 != 0) {
                            throw new CifParseException("readDataBlock: incomplete set of values inside loop" + this.itemErrorMsg(n2, dataItem));
                        }
                        n = 2;
                        n2 = 0;
                        dataItemList2.clear();
                        this.buildr.endLoop();
                        continue;
                    }
                }
                if (n == 2) {
                    if (cifTokenizer.tokenIsName) {
                        DataItem dataItem3 = dataItemList.findDataItem(string);
                        dataItemList2.add(dataItem3);
                        if (n2 == 0) {
                            this.buildr.beginLoop();
                        }
                        this.buildr.setLoopItem(n2, dataItem3);
                        ++n2;
                    } else {
                        n = 3;
                    }
                }
                if (n == 3) {
                    if (cifTokenizer.tokenIsName) {
                        if (n3 != 0) {
                            throw new CifParseException("readDataBlock: Item name found while reading values" + this.itemErrorMsg(n2, dataItem));
                        }
                        n = 1;
                        this.buildr.endLoop();
                    } else {
                        DataItem dataItem4;
                        if (n2 == 0) {
                            throw new CifParseException("readDataBlock: No Item List in loop");
                        }
                        if (n3 == 0) {
                            this.buildr.beginRow();
                        }
                        dataItem = dataItem4 = dataItemList2.elementAt(n3);
                        if (dataItem4 != null) {
                            this.buildr.insertLoopValue(n3, dataItem4, string);
                        }
                        if (++n3 != n2) continue;
                        n3 = 0;
                        this.buildr.endRow();
                        continue;
                    }
                }
                if (n != 1) continue;
                if (cifTokenizer.tokenIsName) {
                    if (bl) {
                        throw new CifParseException("readDataBlock: Item name found where value expected");
                    }
                    dataItem = dataItem2 = dataItemList.findDataItem(string);
                    if (dataItem2 != null) {
                        this.buildr.setSingleItem(dataItem2);
                    }
                    bl = true;
                    continue;
                }
                if (!bl) {
                    throw new CifParseException("readDataBlock: Item value found where name expected" + this.itemErrorMsg(n2, dataItem) + "\n\t<Token>= " + string);
                }
                if (dataItem2 != null) {
                    this.buildr.insertSingleValue(dataItem2, string);
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            System.exit(1);
        }
        this.buildr.endCompound();
    }

    protected String itemErrorMsg(int n, DataItem dataItem) {
        String string = n > 0 ? (dataItem != null ? dataItem.getItemName() : "(Unused DataItem)") : "No DataItems read in this category";
        return "\n\tLast DataItem read: " + string;
    }
}

