/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.openmms.cifparse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.rcsb.openmms.cifparse.CifParseException;
import org.rcsb.openmms.cifparse.UncompressInputStream;

public class CifTokenizer {
    static final boolean debugTokenizer = false;
    public boolean tokenIsName;
    String filename;
    BufferedReader br;
    StreamTokenizer st;
    StringBuffer sbuf = new StringBuffer();
    int linenum = 1;
    static final int NULL_STATE = 1;
    static final int TOKEN_STATE = 2;
    static final int REG_QUOTE_STATE = 3;
    static final int SEMI_QUOTE_STATE = 4;
    static final int WHITESPACE_CHAR = 1;
    static final int REG_QUOTE_CHAR = 2;
    static final int NEWLINE_CHAR = 3;
    static final int OTHER_CHAR = 4;
    BufferedWriter tof;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CifTokenizer(String string) throws IOException {
        this.filename = string;
        if (string.endsWith(".dic")) {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("CifTokenizer: no dictionary resource " + string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.br = new BufferedReader(inputStreamReader);
        } else if (string.startsWith("http:") || string.startsWith("ftp:")) {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (string.endsWith(".zip")) {
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null) {
                    throw new IOException("No ZipEntries in Zip stream");
                }
                InputStreamReader inputStreamReader = new InputStreamReader(zipInputStream);
                this.br = new BufferedReader(inputStreamReader);
            } else if (string.endsWith(".gz")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(gZIPInputStream);
                this.br = new BufferedReader(inputStreamReader);
            } else if (string.endsWith(".Z")) {
                UncompressInputStream uncompressInputStream = new UncompressInputStream(inputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(uncompressInputStream);
                this.br = new BufferedReader(inputStreamReader);
            } else {
                if (!string.endsWith(".cif")) throw new IOException("Unsupported cif file name extension");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                this.br = new BufferedReader(inputStreamReader);
            }
        } else {
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            if (string.endsWith(".zip")) {
                ZipFile zipFile = new ZipFile(string);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) {
                    throw new IOException("No ZipEntries in Zip File");
                }
                this.br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
            } else if (string.endsWith(".gz")) {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(gZIPInputStream);
                this.br = new BufferedReader(inputStreamReader);
            } else if (string.endsWith(".Z")) {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                UncompressInputStream uncompressInputStream = new UncompressInputStream(fileInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(uncompressInputStream);
                this.br = new BufferedReader(inputStreamReader);
            } else {
                FileReader fileReader = new FileReader(string);
                this.br = new BufferedReader(fileReader);
            }
        }
        this.st = new StreamTokenizer(this.br);
        this.st.resetSyntax();
        this.st.wordChars(33, 33);
        this.st.wordChars(36, 38);
        this.st.wordChars(40, 57);
        this.st.wordChars(58, 58);
        this.st.wordChars(60, 62);
        this.st.wordChars(63, 63);
        this.st.wordChars(64, 64);
        this.st.wordChars(65, 90);
        this.st.wordChars(91, 95);
        this.st.wordChars(96, 96);
        this.st.wordChars(97, 122);
        this.st.wordChars(123, 126);
        this.st.eolIsSignificant(true);
    }

    public int getLineNumber() {
        return this.linenum;
    }

    public String getToken() throws IOException, CifParseException {
        String string;
        boolean bl = false;
        this.tokenIsName = false;
        int n = 1;
        int n2 = 4;
        int n3 = 0;
        int n4 = 0;
        block49: while (true) {
            int n5 = n4;
            n4 = this.st.nextToken();
            switch (n4) {
                case -1: {
                    string = null;
                    break block49;
                }
                case -3: {
                    switch (n) {
                        case 1: {
                            n = 2;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            if (n2 != 3) break;
                            this.addToToken(n5);
                        }
                    }
                    this.addToToken(this.st.sval);
                    n2 = 4;
                    continue block49;
                }
                case 35: {
                    block13 : switch (n) {
                        case 1: 
                        case 2: {
                            while (true) {
                                n5 = n4;
                                n4 = this.st.nextToken();
                                switch (n4) {
                                    case -1: {
                                        string = null;
                                        break block49;
                                    }
                                    case 10: {
                                        this.st.pushBack();
                                        break block13;
                                    }
                                }
                            }
                        }
                        case 3: 
                        case 4: {
                            if (n2 == 3) {
                                this.addToToken(n5);
                            }
                            this.addToToken(n4);
                        }
                    }
                    n2 = 4;
                    continue block49;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    switch (n) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            n2 = 1;
                            string = this.endToken();
                            this.st.pushBack();
                            break block49;
                        }
                        case 3: {
                            if (n2 == 2) {
                                n2 = 1;
                                string = this.endToken();
                                this.st.pushBack();
                                break block49;
                            }
                            if (n2 == 3) {
                                this.addToToken(n5);
                            }
                            this.addToToken(n4);
                            break;
                        }
                        case 4: {
                            if (n2 == 3) {
                                this.addToToken(n5);
                            }
                            this.addToToken(n4);
                        }
                    }
                    n2 = 1;
                    continue block49;
                }
                case 34: 
                case 39: {
                    switch (n) {
                        case 1: {
                            if (n2 != 1 && n2 != 3) break;
                            n3 = n4;
                            bl = true;
                            n = 3;
                            break;
                        }
                        case 2: {
                            this.addToToken(n4);
                            break;
                        }
                        case 3: {
                            if (n4 == n3) {
                                if (n2 == 2) {
                                    this.addToToken(n4);
                                }
                                n2 = 2;
                                break;
                            }
                            this.addToToken(n4);
                            break;
                        }
                        case 4: {
                            this.addToToken(n4);
                        }
                    }
                    if (n2 == 2) continue block49;
                    n2 = 4;
                    continue block49;
                }
                case 59: {
                    switch (n) {
                        case 1: {
                            if (n2 != 3) break;
                            bl = true;
                            n = 4;
                            break;
                        }
                        case 2: {
                            this.addToToken(n4);
                            break;
                        }
                        case 3: {
                            this.addToToken(n4);
                            break;
                        }
                        case 4: {
                            if (n2 == 3) {
                                n2 = 4;
                                string = this.endToken();
                                break block49;
                            }
                            this.addToToken(n4);
                        }
                    }
                    n2 = 4;
                    continue block49;
                }
                case 10: {
                    ++this.linenum;
                    switch (n) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            n2 = 3;
                            string = this.endToken();
                            this.st.pushBack();
                            break block49;
                        }
                        case 3: {
                            if (n2 == 2) {
                                n2 = 3;
                                string = this.endToken();
                                this.st.pushBack();
                                break block49;
                            }
                            if (n2 == 3) {
                                this.addToToken(n5);
                            }
                            this.addToToken(this.st.sval);
                            break;
                        }
                        case 4: {
                            if (n2 != 3) break;
                            this.addToToken(n5);
                        }
                    }
                    n2 = 3;
                    continue block49;
                }
                default: {
                    switch (n) {
                        case 3: 
                        case 4: {
                            this.addToToken(n4);
                            break;
                        }
                        case 1: 
                        case 2: {
                            throw new CifParseException("CifTokenizer: Unrecognized token: 0x" + Integer.toString(n4, 16) + "(" + (char)n4 + ")");
                        }
                    }
                    continue block49;
                }
            }
            break;
        }
        this.tokenIsName = string != null && !bl && string.startsWith("_");
        return string;
    }

    public String filename() {
        return this.filename;
    }

    public void close() throws IOException {
        this.br.close();
        this.br = null;
        this.st = null;
    }

    private void addToToken(int n) {
        this.sbuf.append((char)n);
    }

    private void addToToken(String string) {
        this.sbuf.append(string);
    }

    private String endToken() {
        String string = this.sbuf.toString();
        this.sbuf = new StringBuffer();
        return string;
    }

    public void printToken(String string) throws IOException {
        this.tof.flush();
    }
}

