/*
 * Decompiled with CFR 0.152.
 */
package org.interactome.ormapping.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static Configuration configuration;
    private static SessionFactory sessionFactory;

    static {
        try {
            configuration = new Configuration();
            configuration.configure();
            HibernateUtil.rebuildSessionFactory(configuration);
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static SessionFactory getSessionFactory() {
        String sfName = configuration.getProperty("hibernate.session_factory_name");
        if (sfName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfName);
            }
            catch (NamingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (sessionFactory == null) {
            HibernateUtil.rebuildSessionFactory();
        }
        return sessionFactory;
    }

    public static void shutdown() {
        HibernateUtil.getSessionFactory().close();
        sessionFactory = null;
    }

    public static void rebuildSessionFactory() {
        HibernateUtil.rebuildSessionFactory(configuration);
    }

    public static void rebuildSessionFactory(Configuration cfg) {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            sessionFactory.close();
        }
        if (cfg.getProperty("hibernate.session_factory_name") != null) {
            cfg.buildSessionFactory();
        } else {
            sessionFactory = cfg.buildSessionFactory();
        }
        configuration = cfg;
    }

    public static void HandleHibernateException(Session s, Throwable th) {
        HibernateUtil.HandleHibernateException(s, th, false);
    }

    public static void HandleHibernateException(Session s, Throwable th, boolean silently) {
        block8: {
            if (!silently) {
                System.err.println("-------------------------------- HandleHibernateException --------------------------------");
                th.printStackTrace();
            }
            if (s != null) {
                block7: {
                    try {
                        s.connection().rollback();
                    }
                    catch (Exception anye) {
                        if (silently) break block7;
                        System.err.println("------ exception during rollback -------");
                        anye.printStackTrace();
                    }
                }
                try {
                    s.close();
                }
                catch (Exception anye) {
                    if (silently) break block8;
                    System.err.println("------ exception during close -------");
                    anye.printStackTrace();
                }
            }
        }
        if (!silently) {
            System.err.println("------------------------------------------------------------------------------------------");
        }
    }

    public static void HandleHibernateException(StatelessSession s, Throwable th) {
        HibernateUtil.HandleHibernateException(s, th, false);
    }

    public static void HandleHibernateException(StatelessSession s, Throwable th, boolean silently) {
        block8: {
            if (!silently) {
                System.err.println("-------------------------------- HandleHibernateException --------------------------------");
                th.printStackTrace();
            }
            if (s != null) {
                block7: {
                    try {
                        s.connection().rollback();
                    }
                    catch (Exception anye) {
                        if (silently) break block7;
                        System.err.println("------ exception during rollback -------");
                        anye.printStackTrace();
                    }
                }
                try {
                    s.close();
                }
                catch (Exception anye) {
                    if (silently) break block8;
                    System.err.println("------ exception during close -------");
                    anye.printStackTrace();
                }
            }
        }
        if (!silently) {
            System.err.println("------------------------------------------------------------------------------------------");
        }
    }
}

