package org.pdb.beans;

/**
 *  Data items in the ATOM_SITES category record details about
 *  the crystallographic cell and cell transformations, which are
 *  common to all atom sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sitesCategory>
 *  <PDBx:atom_sites entry_id="5HVP">
 *  <PDBx:Cartn_transform_axes>c along z, astar along x, b along y</PDBx:Cartn_transform_axes>
 *  <PDBx:Cartn_transf_matrix11>58.39</PDBx:Cartn_transf_matrix11>
 *  <PDBx:Cartn_transf_matrix12>0.00</PDBx:Cartn_transf_matrix12>
 *  <PDBx:Cartn_transf_matrix13>0.00</PDBx:Cartn_transf_matrix13>
 *  <PDBx:Cartn_transf_matrix21>0.00</PDBx:Cartn_transf_matrix21>
 *  <PDBx:Cartn_transf_matrix22>86.70</PDBx:Cartn_transf_matrix22>
 *  <PDBx:Cartn_transf_matrix23>0.00</PDBx:Cartn_transf_matrix23>
 *  <PDBx:Cartn_transf_matrix31>0.00</PDBx:Cartn_transf_matrix31>
 *  <PDBx:Cartn_transf_matrix32>0.00</PDBx:Cartn_transf_matrix32>
 *  <PDBx:Cartn_transf_matrix33>46.27</PDBx:Cartn_transf_matrix33>
 *  <PDBx:Cartn_transf_vector1>0.00</PDBx:Cartn_transf_vector1>
 *  <PDBx:Cartn_transf_vector2>0.00</PDBx:Cartn_transf_vector2>
 *  <PDBx:Cartn_transf_vector3>0.00</PDBx:Cartn_transf_vector3>
 *  </PDBx:atom_sites>
 *  </PDBx:atom_sitesCategory>
 * </pre>
 */
public class Atom_sites 
{
		protected java.lang.Float Cartn_transf_matrix11;


	/**
	 *  The [1][1] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix11() 
	{
		return Cartn_transf_matrix11;
	}
 
	public void setCartn_transf_matrix11(java.lang.Float Cartn_transf_matrix11)
	{
		this.Cartn_transf_matrix11 = Cartn_transf_matrix11;
	}

 	protected java.lang.Float Cartn_transf_matrix12;


	/**
	 *  The [1][2] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix12() 
	{
		return Cartn_transf_matrix12;
	}
 
	public void setCartn_transf_matrix12(java.lang.Float Cartn_transf_matrix12)
	{
		this.Cartn_transf_matrix12 = Cartn_transf_matrix12;
	}

 	protected java.lang.Float Cartn_transf_matrix13;


	/**
	 *  The [1][3] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix13() 
	{
		return Cartn_transf_matrix13;
	}
 
	public void setCartn_transf_matrix13(java.lang.Float Cartn_transf_matrix13)
	{
		this.Cartn_transf_matrix13 = Cartn_transf_matrix13;
	}

 	protected java.lang.Float Cartn_transf_matrix21;


	/**
	 *  The [2][1] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix21() 
	{
		return Cartn_transf_matrix21;
	}
 
	public void setCartn_transf_matrix21(java.lang.Float Cartn_transf_matrix21)
	{
		this.Cartn_transf_matrix21 = Cartn_transf_matrix21;
	}

 	protected java.lang.Float Cartn_transf_matrix22;


	/**
	 *  The [2][2] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix22() 
	{
		return Cartn_transf_matrix22;
	}
 
	public void setCartn_transf_matrix22(java.lang.Float Cartn_transf_matrix22)
	{
		this.Cartn_transf_matrix22 = Cartn_transf_matrix22;
	}

 	protected java.lang.Float Cartn_transf_matrix23;


	/**
	 *  The [2][3] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix23() 
	{
		return Cartn_transf_matrix23;
	}
 
	public void setCartn_transf_matrix23(java.lang.Float Cartn_transf_matrix23)
	{
		this.Cartn_transf_matrix23 = Cartn_transf_matrix23;
	}

 	protected java.lang.Float Cartn_transf_matrix31;


	/**
	 *  The [3][1] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix31() 
	{
		return Cartn_transf_matrix31;
	}
 
	public void setCartn_transf_matrix31(java.lang.Float Cartn_transf_matrix31)
	{
		this.Cartn_transf_matrix31 = Cartn_transf_matrix31;
	}

 	protected java.lang.Float Cartn_transf_matrix32;


	/**
	 *  The [3][2] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix32() 
	{
		return Cartn_transf_matrix32;
	}
 
	public void setCartn_transf_matrix32(java.lang.Float Cartn_transf_matrix32)
	{
		this.Cartn_transf_matrix32 = Cartn_transf_matrix32;
	}

 	protected java.lang.Float Cartn_transf_matrix33;


	/**
	 *  The [3][3] element of the 3x3 matrix used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute Cartn_transf_vector[].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_matrix33() 
	{
		return Cartn_transf_matrix33;
	}
 
	public void setCartn_transf_matrix33(java.lang.Float Cartn_transf_matrix33)
	{
		this.Cartn_transf_matrix33 = Cartn_transf_matrix33;
	}

 	protected java.lang.Float Cartn_transf_vector1;


	/**
	 *  The [1] element of the three-element vector used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The rotation matrix is defined in
	 *  attribute Cartn_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_vector1() 
	{
		return Cartn_transf_vector1;
	}
 
	public void setCartn_transf_vector1(java.lang.Float Cartn_transf_vector1)
	{
		this.Cartn_transf_vector1 = Cartn_transf_vector1;
	}

 	protected java.lang.Float Cartn_transf_vector2;


	/**
	 *  The [2] element of the three-element vector used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The rotation matrix is defined in
	 *  attribute Cartn_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_vector2() 
	{
		return Cartn_transf_vector2;
	}
 
	public void setCartn_transf_vector2(java.lang.Float Cartn_transf_vector2)
	{
		this.Cartn_transf_vector2 = Cartn_transf_vector2;
	}

 	protected java.lang.Float Cartn_transf_vector3;


	/**
	 *  The [3] element of the three-element vector used to transform
	 *  fractional coordinates in the ATOM_SITE category to Cartesian
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The rotation matrix is defined in
	 *  attribute Cartn_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|              |11 12 13| |x|               |1|
	 *  |y'|~Cartesian~ = |21 22 23| |y|~fractional~ + |2|
	 *  |z'|              |31 32 33| |z|               |3|
	 */
	public java.lang.Float getCartn_transf_vector3() 
	{
		return Cartn_transf_vector3;
	}
 
	public void setCartn_transf_vector3(java.lang.Float Cartn_transf_vector3)
	{
		this.Cartn_transf_vector3 = Cartn_transf_vector3;
	}

 	protected java.lang.String Cartn_transform_axes;


	/**
	 *  A description of the relative alignment of the crystal cell
	 *  axes to the Cartesian orthogonal axes as applied in the
	 *  transformation matrix  attribute Cartn_transf_matrix[][] in category atom_sites.
	 *  a parallel to x; b in the plane of y and z
	 */
	public java.lang.String getCartn_transform_axes() 
	{
		return Cartn_transform_axes;
	}
 
	public void setCartn_transform_axes(java.lang.String Cartn_transform_axes)
	{
		this.Cartn_transform_axes = Cartn_transform_axes;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float fract_transf_matrix11;


	/**
	 *  The [1][1] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix11() 
	{
		return fract_transf_matrix11;
	}
 
	public void setFract_transf_matrix11(java.lang.Float fract_transf_matrix11)
	{
		this.fract_transf_matrix11 = fract_transf_matrix11;
	}

 	protected java.lang.Float fract_transf_matrix12;


	/**
	 *  The [1][2] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix12() 
	{
		return fract_transf_matrix12;
	}
 
	public void setFract_transf_matrix12(java.lang.Float fract_transf_matrix12)
	{
		this.fract_transf_matrix12 = fract_transf_matrix12;
	}

 	protected java.lang.Float fract_transf_matrix13;


	/**
	 *  The [1][3] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix13() 
	{
		return fract_transf_matrix13;
	}
 
	public void setFract_transf_matrix13(java.lang.Float fract_transf_matrix13)
	{
		this.fract_transf_matrix13 = fract_transf_matrix13;
	}

 	protected java.lang.Float fract_transf_matrix21;


	/**
	 *  The [2][1] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix21() 
	{
		return fract_transf_matrix21;
	}
 
	public void setFract_transf_matrix21(java.lang.Float fract_transf_matrix21)
	{
		this.fract_transf_matrix21 = fract_transf_matrix21;
	}

 	protected java.lang.Float fract_transf_matrix22;


	/**
	 *  The [2][2] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix22() 
	{
		return fract_transf_matrix22;
	}
 
	public void setFract_transf_matrix22(java.lang.Float fract_transf_matrix22)
	{
		this.fract_transf_matrix22 = fract_transf_matrix22;
	}

 	protected java.lang.Float fract_transf_matrix23;


	/**
	 *  The [2][3] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix23() 
	{
		return fract_transf_matrix23;
	}
 
	public void setFract_transf_matrix23(java.lang.Float fract_transf_matrix23)
	{
		this.fract_transf_matrix23 = fract_transf_matrix23;
	}

 	protected java.lang.Float fract_transf_matrix31;


	/**
	 *  The [3][1] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix31() 
	{
		return fract_transf_matrix31;
	}
 
	public void setFract_transf_matrix31(java.lang.Float fract_transf_matrix31)
	{
		this.fract_transf_matrix31 = fract_transf_matrix31;
	}

 	protected java.lang.Float fract_transf_matrix32;


	/**
	 *  The [3][2] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix32() 
	{
		return fract_transf_matrix32;
	}
 
	public void setFract_transf_matrix32(java.lang.Float fract_transf_matrix32)
	{
		this.fract_transf_matrix32 = fract_transf_matrix32;
	}

 	protected java.lang.Float fract_transf_matrix33;


	/**
	 *  The [3][3] element of the 3x3 matrix used to transform Cartesian
	 *  coordinates in the ATOM_SITE category to fractional coordinates
	 *  in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x1 translation is defined in
	 *  attribute fract_transf_vector[].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_matrix33() 
	{
		return fract_transf_matrix33;
	}
 
	public void setFract_transf_matrix33(java.lang.Float fract_transf_matrix33)
	{
		this.fract_transf_matrix33 = fract_transf_matrix33;
	}

 	protected java.lang.Float fract_transf_vector1;


	/**
	 *  The [1] element of the three-element vector used to transform
	 *  Cartesian coordinates in the ATOM_SITE category to fractional
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x3 rotation is defined in
	 *  attribute fract_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_vector1() 
	{
		return fract_transf_vector1;
	}
 
	public void setFract_transf_vector1(java.lang.Float fract_transf_vector1)
	{
		this.fract_transf_vector1 = fract_transf_vector1;
	}

 	protected java.lang.Float fract_transf_vector2;


	/**
	 *  The [2] element of the three-element vector used to transform
	 *  Cartesian coordinates in the ATOM_SITE category to fractional
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x3 rotation is defined in
	 *  attribute fract_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_vector2() 
	{
		return fract_transf_vector2;
	}
 
	public void setFract_transf_vector2(java.lang.Float fract_transf_vector2)
	{
		this.fract_transf_vector2 = fract_transf_vector2;
	}

 	protected java.lang.Float fract_transf_vector3;


	/**
	 *  The [3] element of the three-element vector used to transform
	 *  Cartesian coordinates in the ATOM_SITE category to fractional
	 *  coordinates in the same category. The axial alignments of this
	 *  transformation are described in  attribute Cartn_transform_axes.
	 *  in category atom_sites The 3x3 rotation is defined in
	 *  attribute fract_transf_matrix[][].
	 *  in category atom_sites
	 *  |x'|               |11 12 13| |x|              |1|
	 *  |y'|~fractional~ = |21 22 23| |y|~Cartesian~ + |2|
	 *  |z'|               |31 32 33| |z|              |3|
	 */
	public java.lang.Float getFract_transf_vector3() 
	{
		return fract_transf_vector3;
	}
 
	public void setFract_transf_vector3(java.lang.Float fract_transf_vector3)
	{
		this.fract_transf_vector3 = fract_transf_vector3;
	}

 	protected java.lang.String solution_hydrogens;


	/**
	 *  This code identifies the method used to locate the
	 *  hydrogen atoms.
	 *  
	 *  *** This data item would not in general be used in a
	 *  macromolecular data block. ***
	 */
	public java.lang.String getSolution_hydrogens() 
	{
		return solution_hydrogens;
	}
 
	public void setSolution_hydrogens(java.lang.String solution_hydrogens)
	{
		this.solution_hydrogens = solution_hydrogens;
	}

 	protected java.lang.String solution_primary;


	/**
	 *  This code identifies the method used to locate the initial
	 *  atom sites.
	 *  
	 *  *** This data item would not in general be used in a
	 *  macromolecular data block. ***
	 */
	public java.lang.String getSolution_primary() 
	{
		return solution_primary;
	}
 
	public void setSolution_primary(java.lang.String solution_primary)
	{
		this.solution_primary = solution_primary;
	}

 	protected java.lang.String solution_secondary;


	/**
	 *  This code identifies the method used to locate the
	 *  non-hydrogen-atom sites not found by
	 *  attribute solution_primary.
	 *  in category atom_sites
	 *  *** This data item would not in general be used in a
	 *  macromolecular data block. ***
	 */
	public java.lang.String getSolution_secondary() 
	{
		return solution_secondary;
	}
 
	public void setSolution_secondary(java.lang.String solution_secondary)
	{
		this.solution_secondary = solution_secondary;
	}

 	protected java.lang.String special_details;


	/**
	 *  Additional information about the atomic coordinates not coded
	 *  elsewhere in the CIF.
	 */
	public java.lang.String getSpecial_details() 
	{
		return special_details;
	}
 
	public void setSpecial_details(java.lang.String special_details)
	{
		this.special_details = special_details;
	}

 }
