package org.pdb.beans;

/**
 *  Data items in the ATOM_SITES_ALT category record details
 *  about the structural ensembles that should be generated from
 *  atom sites or groups of atom sites that are modelled in
 *  alternative conformations in this data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_altCategory>
 *  <PDBx:atom_sites_alt id="">
 *  <PDBx:details> Atom sites with the alternative ID set to null are not
 *  modeled in alternative conformations</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="1">
 *  <PDBx:details> Atom sites with the alternative ID set to 1 have been
 *  modeled in alternative conformations with respect to atom
 *  sites marked with alternative ID 2. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 1 correlate with the conformation of the
 *  inhibitor marked with alternative ID 1. They have been
 *  given an occupancy of 0.58 to match the occupancy assigned
 *  to the inhibitor.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="2">
 *  <PDBx:details> Atom sites with the alternative ID set to 2 have been
 *  modeled in alternative conformations with respect to atom
 *  sites marked with alternative ID 1. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 2 correlate with the conformation of the
 *  inhibitor marked with alternative ID 2. They have been
 *  given an occupancy of 0.42 to match the occupancy assigned
 *  to the inhibitor.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="3">
 *  <PDBx:details> Atom sites with the alternative ID set to 3 have been
 *  modeled in alternative conformations with respect to
 *  atoms marked with alternative ID 4. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 3 do not correlate with the conformation of the
 *  inhibitor. These atom sites have arbitrarily been given
 *  an occupancy of 0.50.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  <PDBx:atom_sites_alt id="4">
 *  <PDBx:details> Atom sites with the alternative ID set to 4 have been
 *  modeled in alternative conformations with respect to
 *  atoms marked with alternative ID 3. The conformations of
 *  amino-acid side chains and solvent atoms with alternative
 *  ID set to 4 do not correlate with the conformation of the
 *  inhibitor. These atom sites have arbitrarily been given
 *  an occupancy of 0.50.</PDBx:details>
 *  </PDBx:atom_sites_alt>
 *  </PDBx:atom_sites_altCategory>
 * </pre>
 */
public class Atom_sites_alt 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the modelling of atoms in
	 *  alternative conformations.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category atom_sites_alt must uniquely identify
	 *  a record in the ATOM_SITES_ALT list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  orientation 1
	 *  molecule abc
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
