package org.pdb.beans;

/**
 *  Data items in the ATOM_SITES_FOOTNOTE category record detailed
 *  comments about an atom site or a group of atom sites.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_sites_footnoteCategory>
 *  <PDBx:atom_sites_footnote id="1">
 *  <PDBx:text> The inhibitor binds to the enzyme in two alternative
 *  orientations. The two orientations have been assigned
 *  alternative IDs *1* and *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="2">
 *  <PDBx:text> Side chains of these residues adopt alternative
 *  orientations that correlate with the alternative
 *  orientations of the inhibitor.
 *  Side chains with alternative ID *1* and occupancy 0.58
 *  correlate with inhibitor orientation *1*.
 *  Side chains with alternative ID *2* and occupancy 0.42
 *  correlate with inhibitor orientation *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="3">
 *  <PDBx:text> The positions of these water molecules correlate with
 *  the alternative orientations of the inhibitor.
 *  Water molecules with alternative ID *1* and occupancy 0.58
 *  correlate with inhibitor orientation *1*.
 *  Water molecules with alternative ID *2* and occupancy 0.42
 *  correlate with inhibitor orientation *2*.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="4">
 *  <PDBx:text> Side chains of these residues adopt alternative
 *  orientations that do not correlate with the alternative
 *  orientation of the inhibitor.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  <PDBx:atom_sites_footnote id="5">
 *  <PDBx:text> The positions of these water molecules correlate with
 *  alternative orientations of amino-acid side chains that
 *  do not correlate with alternative orientations of the
 *  inhibitor.</PDBx:text>
 *  </PDBx:atom_sites_footnote>
 *  </PDBx:atom_sites_footnoteCategory>
 * </pre>
 */
public class Atom_sites_footnote 
{
		protected java.lang.String id_;


	/**
	 *  A code that identifies the footnote.
	 *  a
	 *  b
	 *  1
	 *  2
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String text;


	/**
	 *  The text of the footnote. Footnotes are used to describe
	 *  an atom site or a group of atom sites in the ATOM_SITE list.
	 *  
	 *  For example, footnotes may be used to indicate atoms for which
	 *  the electron density is very weak, or atoms for which static
	 *  disorder has been modelled.
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
