package org.pdb.beans;

/**
 *  Data items in the ATOM_TYPE category record details about the
 *  properties of the atoms that occupy the atom sites, such as the
 *  atomic scattering factors.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:atom_typeCategory>
 *  <PDBx:atom_type symbol="C">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>2.31000</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>20.8439</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>1.02000</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>10.2075</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.58860</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.568700</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>0.865000</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>51.6512</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.21560</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="N">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>12.2126</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>0.005700</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>3.13220</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>9.89330</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>2.01250</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>28.9975</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>1.16630</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>0.582600</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>-11.529</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="O">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>3.04850</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>13.2771</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>2.28680</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>5.70110</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.54630</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.323900</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>0.867000</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>32.9089</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.250800</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="S">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>6.90530</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>1.46790</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>5.20340</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>22.2151</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>1.43790</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>0.253600</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>1.58630</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>56.1720</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>0.866900</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="CL">
 *  <PDBx:oxidation_number>-1</PDBx:oxidation_number>
 *  <PDBx:scat_Cromer_Mann_a1>18.2915</PDBx:scat_Cromer_Mann_a1>
 *  <PDBx:scat_Cromer_Mann_a2>0.006600</PDBx:scat_Cromer_Mann_a2>
 *  <PDBx:scat_Cromer_Mann_a3>7.20840</PDBx:scat_Cromer_Mann_a3>
 *  <PDBx:scat_Cromer_Mann_a4>1.17170</PDBx:scat_Cromer_Mann_a4>
 *  <PDBx:scat_Cromer_Mann_b1>6.53370</PDBx:scat_Cromer_Mann_b1>
 *  <PDBx:scat_Cromer_Mann_b2>19.5424</PDBx:scat_Cromer_Mann_b2>
 *  <PDBx:scat_Cromer_Mann_b3>2.33860</PDBx:scat_Cromer_Mann_b3>
 *  <PDBx:scat_Cromer_Mann_b4>60.4486</PDBx:scat_Cromer_Mann_b4>
 *  <PDBx:scat_Cromer_Mann_c>-16.378</PDBx:scat_Cromer_Mann_c>
 *  </PDBx:atom_type>
 *  </PDBx:atom_typeCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:atom_typeCategory>
 *  <PDBx:atom_type symbol="C">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>72</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.017</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.009</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="H">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>100</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>0.</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>0.</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="O">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>12</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.047</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.032</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  <PDBx:atom_type symbol="N">
 *  <PDBx:oxidation_number>0</PDBx:oxidation_number>
 *  <PDBx:number_in_cell>4</PDBx:number_in_cell>
 *  <PDBx:scat_dispersion_real>.029</PDBx:scat_dispersion_real>
 *  <PDBx:scat_dispersion_imag>.018</PDBx:scat_dispersion_imag>
 *  <PDBx:scat_source>International_Tables_Vol_IV_Table_2.2B</PDBx:scat_source>
 *  </PDBx:atom_type>
 *  </PDBx:atom_typeCategory>
 * </pre>
 */
public class Atom_type 
{
		protected java.lang.Float analytical_mass_percent;


	/**
	 *  Mass percentage of this atom type derived from chemical analysis.
	 */
	public java.lang.Float getAnalytical_mass_percent() 
	{
		return analytical_mass_percent;
	}
 
	public void setAnalytical_mass_percent(java.lang.Float analytical_mass_percent)
	{
		this.analytical_mass_percent = analytical_mass_percent;
	}

 	protected java.lang.String description;


	/**
	 *  A description of the atom(s) designated by this atom type. In
	 *  most cases, this is the element name and oxidation state of
	 *  a single atom species. For disordered or nonstoichiometric
	 *  structures it will describe a combination of atom species.
	 *  deuterium
	 *  0.34Fe+0.66Ni
	 */
	public java.lang.String getDescription() 
	{
		return description;
	}
 
	public void setDescription(java.lang.String description)
	{
		this.description = description;
	}

 	protected java.lang.Integer number_in_cell;


	/**
	 *  Total number of atoms of this atom type in the unit cell.
	 */
	public java.lang.Integer getNumber_in_cell() 
	{
		return number_in_cell;
	}
 
	public void setNumber_in_cell(java.lang.Integer number_in_cell)
	{
		this.number_in_cell = number_in_cell;
	}

 	protected java.lang.Integer oxidation_number;


	/**
	 *  Formal oxidation state of this atom type in the structure.
	 */
	public java.lang.Integer getOxidation_number() 
	{
		return oxidation_number;
	}
 
	public void setOxidation_number(java.lang.Integer oxidation_number)
	{
		this.oxidation_number = oxidation_number;
	}

 	protected java.lang.Float radius_bond;


	/**
	 *  The effective intramolecular bonding radius in angstroms
	 *  of this atom type.
	 */
	public java.lang.Float getRadius_bond() 
	{
		return radius_bond;
	}
 
	public void setRadius_bond(java.lang.Float radius_bond)
	{
		this.radius_bond = radius_bond;
	}

 	protected java.lang.Float radius_contact;


	/**
	 *  The effective intermolecular bonding radius in angstroms
	 *  of this atom type.
	 */
	public java.lang.Float getRadius_contact() 
	{
		return radius_contact;
	}
 
	public void setRadius_contact(java.lang.Float radius_contact)
	{
		this.radius_contact = radius_contact;
	}

 	protected java.lang.Float scat_Cromer_Mann_a1;


	/**
	 *  The Cromer-Mann scattering-factor coefficient a1 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_a1() 
	{
		return scat_Cromer_Mann_a1;
	}
 
	public void setScat_Cromer_Mann_a1(java.lang.Float scat_Cromer_Mann_a1)
	{
		this.scat_Cromer_Mann_a1 = scat_Cromer_Mann_a1;
	}

 	protected java.lang.Float scat_Cromer_Mann_a2;


	/**
	 *  The Cromer-Mann scattering-factor coefficient a2 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_a2() 
	{
		return scat_Cromer_Mann_a2;
	}
 
	public void setScat_Cromer_Mann_a2(java.lang.Float scat_Cromer_Mann_a2)
	{
		this.scat_Cromer_Mann_a2 = scat_Cromer_Mann_a2;
	}

 	protected java.lang.Float scat_Cromer_Mann_a3;


	/**
	 *  The Cromer-Mann scattering-factor coefficient a3 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_a3() 
	{
		return scat_Cromer_Mann_a3;
	}
 
	public void setScat_Cromer_Mann_a3(java.lang.Float scat_Cromer_Mann_a3)
	{
		this.scat_Cromer_Mann_a3 = scat_Cromer_Mann_a3;
	}

 	protected java.lang.Float scat_Cromer_Mann_a4;


	/**
	 *  The Cromer-Mann scattering-factor coefficient a4 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_a4() 
	{
		return scat_Cromer_Mann_a4;
	}
 
	public void setScat_Cromer_Mann_a4(java.lang.Float scat_Cromer_Mann_a4)
	{
		this.scat_Cromer_Mann_a4 = scat_Cromer_Mann_a4;
	}

 	protected java.lang.Float scat_Cromer_Mann_b1;


	/**
	 *  The Cromer-Mann scattering-factor coefficient b1 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_b1() 
	{
		return scat_Cromer_Mann_b1;
	}
 
	public void setScat_Cromer_Mann_b1(java.lang.Float scat_Cromer_Mann_b1)
	{
		this.scat_Cromer_Mann_b1 = scat_Cromer_Mann_b1;
	}

 	protected java.lang.Float scat_Cromer_Mann_b2;


	/**
	 *  The Cromer-Mann scattering-factor coefficient b2 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_b2() 
	{
		return scat_Cromer_Mann_b2;
	}
 
	public void setScat_Cromer_Mann_b2(java.lang.Float scat_Cromer_Mann_b2)
	{
		this.scat_Cromer_Mann_b2 = scat_Cromer_Mann_b2;
	}

 	protected java.lang.Float scat_Cromer_Mann_b3;


	/**
	 *  The Cromer-Mann scattering-factor coefficient b3 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_b3() 
	{
		return scat_Cromer_Mann_b3;
	}
 
	public void setScat_Cromer_Mann_b3(java.lang.Float scat_Cromer_Mann_b3)
	{
		this.scat_Cromer_Mann_b3 = scat_Cromer_Mann_b3;
	}

 	protected java.lang.Float scat_Cromer_Mann_b4;


	/**
	 *  The Cromer-Mann scattering-factor coefficient b4 used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_b4() 
	{
		return scat_Cromer_Mann_b4;
	}
 
	public void setScat_Cromer_Mann_b4(java.lang.Float scat_Cromer_Mann_b4)
	{
		this.scat_Cromer_Mann_b4 = scat_Cromer_Mann_b4;
	}

 	protected java.lang.Float scat_Cromer_Mann_c;


	/**
	 *  The Cromer-Mann scattering-factor coefficient c used to
	 *  calculate the scattering factors for this atom type.
	 *  
	 *  Ref: International Tables for X-ray Crystallography (1974).
	 *  Vol. IV, Table 2.2B
	 *  or: International Tables for Crystallography  (2004). Vol. C,
	 *  Tables 6.1.1.4 and 6.1.1.5.
	 */
	public java.lang.Float getScat_Cromer_Mann_c() 
	{
		return scat_Cromer_Mann_c;
	}
 
	public void setScat_Cromer_Mann_c(java.lang.Float scat_Cromer_Mann_c)
	{
		this.scat_Cromer_Mann_c = scat_Cromer_Mann_c;
	}

 	protected java.lang.Float scat_dispersion_imag;


	/**
	 *  The imaginary component of the anomalous-dispersion
	 *  scattering factor, f'', in electrons for this atom type and
	 *  the radiation identified by  attribute id in category diffrn_radiation_wavelength.
	 */
	public java.lang.Float getScat_dispersion_imag() 
	{
		return scat_dispersion_imag;
	}
 
	public void setScat_dispersion_imag(java.lang.Float scat_dispersion_imag)
	{
		this.scat_dispersion_imag = scat_dispersion_imag;
	}

 	protected java.lang.Float scat_dispersion_real;


	/**
	 *  The real component of the anomalous-dispersion
	 *  scattering factor, f', in electrons for this atom type and
	 *  the radiation identified by  attribute id in category diffrn_radiation_wavelength.
	 */
	public java.lang.Float getScat_dispersion_real() 
	{
		return scat_dispersion_real;
	}
 
	public void setScat_dispersion_real(java.lang.Float scat_dispersion_real)
	{
		this.scat_dispersion_real = scat_dispersion_real;
	}

 	protected java.lang.String scat_dispersion_source;


	/**
	 *  Reference to the source of the real and imaginary dispersion
	 *  corrections for scattering factors used for this atom type.
	 *  International Tables Vol. IV Table 2.3.1
	 */
	public java.lang.String getScat_dispersion_source() 
	{
		return scat_dispersion_source;
	}
 
	public void setScat_dispersion_source(java.lang.String scat_dispersion_source)
	{
		this.scat_dispersion_source = scat_dispersion_source;
	}

 	protected java.lang.Float scat_length_neutron;


	/**
	 *  The bound coherent scattering length in femtometres for the
	 *  atom type at the isotopic composition used for the diffraction
	 *  experiment.
	 */
	public java.lang.Float getScat_length_neutron() 
	{
		return scat_length_neutron;
	}
 
	public void setScat_length_neutron(java.lang.Float scat_length_neutron)
	{
		this.scat_length_neutron = scat_length_neutron;
	}

 	protected java.lang.String scat_source;


	/**
	 *  Reference to the source of the scattering factors or scattering
	 *  lengths used for this atom type.
	 *  International Tables Vol. IV Table 2.4.6B
	 */
	public java.lang.String getScat_source() 
	{
		return scat_source;
	}
 
	public void setScat_source(java.lang.String scat_source)
	{
		this.scat_source = scat_source;
	}

 	protected java.lang.String scat_versus_stol_list;


	/**
	 *  A table of scattering factors as a function of sin theta over
	 *  lambda. This table should be well commented to indicate the
	 *  items present. Regularly formatted lists are strongly
	 *  recommended.
	 */
	public java.lang.String getScat_versus_stol_list() 
	{
		return scat_versus_stol_list;
	}
 
	public void setScat_versus_stol_list(java.lang.String scat_versus_stol_list)
	{
		this.scat_versus_stol_list = scat_versus_stol_list;
	}

 	protected java.lang.String symbol;


	/**
	 *  The code used to identify the atom species (singular or plural)
	 *  representing this atom type. Normally this code is the element
	 *  symbol. The code may be composed of any character except
	 *  an underscore with the additional proviso that digits designate
	 *  an oxidation state and must be followed by a + or - character.
	 *  C
	 *  Cu2+
	 *  H(SDS)
	 *  dummy
	 *  FeNi
	 */
	public java.lang.String getSymbol() 
	{
		return symbol;
	}
 
	public void setSymbol(java.lang.String symbol)
	{
		this.symbol = symbol;
	}

 }
