package org.pdb.beans;

/**
 *  Data items in the AUDIT_AUTHOR category record details about
 *  the author(s) of the data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:audit_authorCategory>
 *  <PDBx:audit_author name="Fitzgerald, Paula M.D.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:audit_author>
 *  <PDBx:audit_author name="McKeever, Brian M.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:audit_author>
 *  <PDBx:audit_author name="Van Middlesworth, J.F.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:audit_author>
 *  <PDBx:audit_author name="Springer, James P.">
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:audit_author>
 *  </PDBx:audit_authorCategory>
 * </pre>
 */
public class Audit_author 
{
		protected java.lang.String address;


	/**
	 *  The address of an author of this data block. If there are
	 *  multiple authors,  attribute address in category audit_author is looped with
	 *  attribute name in category audit_author.
	 *  Department
	 *  Institute
	 *  Street
	 *  City and postcode
	 *  COUNTRY
	 */
	public java.lang.String getAddress() 
	{
		return address;
	}
 
	public void setAddress(java.lang.String address)
	{
		this.address = address;
	}

 	protected java.lang.String name;


	/**
	 *  The name of an author of this data block. If there are multiple
	 *  authors, _audit_author.name is looped with _audit_author.address.
	 *  The family name(s), followed by a comma and including any
	 *  dynastic components, precedes the first name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 }
