package org.pdb.beans;

/**
 *  Data items in the CELL_MEASUREMENT category record details
 *  about the measurement of the crystallographic cell parameters.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:cell_measurementCategory>
 *  <PDBx:cell_measurement entry_id="5HVP">
 *  <PDBx:temp>293.</PDBx:temp>
 *  <PDBx:temp_esd>3.</PDBx:temp_esd>
 *  <PDBx:theta_min>11.</PDBx:theta_min>
 *  <PDBx:theta_max>31.</PDBx:theta_max>
 *  <PDBx:wavelength>1.54</PDBx:wavelength>
 *  </PDBx:cell_measurement>
 *  </PDBx:cell_measurementCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:cell_measurementCategory>
 *  <PDBx:cell_measurement>
 *  <PDBx:temp>293.</PDBx:temp>
 *  <PDBx:reflns_used>25</PDBx:reflns_used>
 *  <PDBx:theta_min>25.</PDBx:theta_min>
 *  <PDBx:theta_max>31.</PDBx:theta_max>
 *  </PDBx:cell_measurement>
 *  </PDBx:cell_measurementCategory>
 * </pre>
 */
public class Cell_measurement 
{
		protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float pressure;


	/**
	 *  The pressure in kilopascals at which the unit-cell parameters
	 *  were measured (not the pressure at which the sample was
	 *  synthesized).
	 */
	public java.lang.Float getPressure() 
	{
		return pressure;
	}
 
	public void setPressure(java.lang.Float pressure)
	{
		this.pressure = pressure;
	}

 	protected java.lang.Float pressure_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute pressure in category cell_measurement.
	 */
	public java.lang.Float getPressure_esd() 
	{
		return pressure_esd;
	}
 
	public void setPressure_esd(java.lang.Float pressure_esd)
	{
		this.pressure_esd = pressure_esd;
	}

 	protected java.lang.String radiation;


	/**
	 *  Description of the radiation used to measure the unit-cell data.
	 *  See also  attribute wavelength in category cell_measurement.
	 *  neutron
	 *  Cu K\a
	 *  synchrotron
	 */
	public java.lang.String getRadiation() 
	{
		return radiation;
	}
 
	public void setRadiation(java.lang.String radiation)
	{
		this.radiation = radiation;
	}

 	protected java.lang.Integer reflns_used;


	/**
	 *  The total number of reflections used to determine the unit cell.
	 *  These reflections may be specified as CELL_MEASUREMENT_REFLN
	 *  data items.
	 */
	public java.lang.Integer getReflns_used() 
	{
		return reflns_used;
	}
 
	public void setReflns_used(java.lang.Integer reflns_used)
	{
		this.reflns_used = reflns_used;
	}

 	protected java.lang.Float temp;


	/**
	 *  The temperature in kelvins at which the unit-cell parameters
	 *  were measured (not the temperature of synthesis).
	 */
	public java.lang.Float getTemp() 
	{
		return temp;
	}
 
	public void setTemp(java.lang.Float temp)
	{
		this.temp = temp;
	}

 	protected java.lang.Float temp_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute temp in category cell_measurement.
	 */
	public java.lang.Float getTemp_esd() 
	{
		return temp_esd;
	}
 
	public void setTemp_esd(java.lang.Float temp_esd)
	{
		this.temp_esd = temp_esd;
	}

 	protected java.lang.Float theta_max;


	/**
	 *  The maximum theta angle of reflections used to measure
	 *  the unit cell in degrees.
	 */
	public java.lang.Float getTheta_max() 
	{
		return theta_max;
	}
 
	public void setTheta_max(java.lang.Float theta_max)
	{
		this.theta_max = theta_max;
	}

 	protected java.lang.Float theta_min;


	/**
	 *  The minimum theta angle of reflections used to measure
	 *  the unit cell in degrees.
	 */
	public java.lang.Float getTheta_min() 
	{
		return theta_min;
	}
 
	public void setTheta_min(java.lang.Float theta_min)
	{
		this.theta_min = theta_min;
	}

 	protected java.lang.Float wavelength;


	/**
	 *  The wavelength in angstroms of the radiation used to measure
	 *  the unit cell. If this is not specified, the wavelength is
	 *  assumed to be that specified in the category
	 *  DIFFRN_RADIATION_WAVELENGTH.
	 */
	public java.lang.Float getWavelength() 
	{
		return wavelength;
	}
 
	public void setWavelength(java.lang.Float wavelength)
	{
		this.wavelength = wavelength;
	}

 }
