package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP category give details about each
 *  of the chemical components from which the relevant chemical
 *  structures can be constructed, such as name, mass or charge.
 *  
 *  The related categories CHEM_COMP_ATOM, CHEM_COMP_BOND,
 *  CHEM_COMP_ANGLE etc. describe the detailed geometry of these
 *  chemical components.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_compCategory>
 *  <PDBx:chem_comp id="phe">
 *  <PDBx:model_source>1987 Protin/Prolsq Ideals file</PDBx:model_source>
 *  <PDBx:name>phenylalanine</PDBx:name>
 *  </PDBx:chem_comp>
 *  <PDBx:chem_comp id="val">
 *  <PDBx:model_source>1987 Protin/Prolsq Ideals file</PDBx:model_source>
 *  <PDBx:name>alanine</PDBx:name>
 *  </PDBx:chem_comp>
 *  </PDBx:chem_compCategory>
 * </pre>
 */
public class Chem_comp 
{
		protected java.lang.String formula;


	/**
	 *  The formula for the chemical component. Formulae are written
	 *  according to the following rules:
	 *  
	 *  (1) Only recognized element symbols may be used.
	 *  
	 *  (2) Each element symbol is followed by a 'count' number. A count
	 *  of '1' may be omitted.
	 *  
	 *  (3) A space or parenthesis must separate each cluster of
	 *  (element symbol + count), but in general parentheses are
	 *  not used.
	 *  
	 *  (4) The order of elements depends on whether carbon is
	 *  present or not. If carbon is present, the order should be:
	 *  C, then H, then the other elements in alphabetical order
	 *  of their symbol. If carbon is not present, the elements
	 *  are listed purely in alphabetic order of their symbol. This
	 *  is the 'Hill' system used by Chemical Abstracts.
	 *  C18 H19 N7 O8 S
	 */
	public java.lang.String getFormula() 
	{
		return formula;
	}
 
	public void setFormula(java.lang.String formula)
	{
		this.formula = formula;
	}

 	protected java.lang.Float formula_weight;


	/**
	 *  Formula mass in daltons of the chemical component.
	 */
	public java.lang.Float getFormula_weight() 
	{
		return formula_weight;
	}
 
	public void setFormula_weight(java.lang.Float formula_weight)
	{
		this.formula_weight = formula_weight;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category chem_comp must uniquely identify each item in
	 *  the CHEM_COMP list.
	 *  
	 *  For protein polymer entities, this is the three-letter code for
	 *  the amino acid.
	 *  
	 *  For nucleic acid polymer entities, this is the one-letter code
	 *  for the base.
	 *  ALA
	 *  VAL
	 *  DG
	 *  C
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String model_details;


	/**
	 *  A description of special aspects of the generation of the
	 *  coordinates for the model of the component.
	 *  geometry idealized but not minimized
	 */
	public java.lang.String getModel_details() 
	{
		return model_details;
	}
 
	public void setModel_details(java.lang.String model_details)
	{
		this.model_details = model_details;
	}

 	protected java.lang.String model_erf;


	/**
	 *  A pointer to an external reference file from which the atomic
	 *  description of the component is taken.
	 */
	public java.lang.String getModel_erf() 
	{
		return model_erf;
	}
 
	public void setModel_erf(java.lang.String model_erf)
	{
		this.model_erf = model_erf;
	}

 	protected java.lang.String model_source;


	/**
	 *  The source of the coordinates for the model of the component.
	 *  CSD entry ABCDEF
	 *  built using Quanta/Charmm
	 */
	public java.lang.String getModel_source() 
	{
		return model_source;
	}
 
	public void setModel_source(java.lang.String model_source)
	{
		this.model_source = model_source;
	}

 	protected java.lang.String mon_nstd_class;


	/**
	 *  A description of the class of a nonstandard monomer if the
	 *  nonstandard monomer represents a modification of a
	 *  standard monomer.
	 *  iodinated base
	 *  phosphorylated amino acid
	 *  brominated base
	 *  modified amino acid
	 *  glycosylated amino acid
	 */
	public java.lang.String getMon_nstd_class() 
	{
		return mon_nstd_class;
	}
 
	public void setMon_nstd_class(java.lang.String mon_nstd_class)
	{
		this.mon_nstd_class = mon_nstd_class;
	}

 	protected java.lang.String mon_nstd_details;


	/**
	 *  A description of special details of a nonstandard monomer.
	 */
	public java.lang.String getMon_nstd_details() 
	{
		return mon_nstd_details;
	}
 
	public void setMon_nstd_details(java.lang.String mon_nstd_details)
	{
		this.mon_nstd_details = mon_nstd_details;
	}

 	protected java.lang.String mon_nstd_flag;


	/**
	 *  'yes' indicates that this is a 'standard' monomer, 'no'
	 *  indicates that it is 'nonstandard'. Nonstandard monomers
	 *  should be described in more detail using the
	 *  _chem_comp.mon_nstd_parent, _chem_comp.mon_nstd_class and
	 *  attribute mon_nstd_details in category chem_comp data items.
	 */
	public java.lang.String getMon_nstd_flag() 
	{
		return mon_nstd_flag;
	}
 
	public void setMon_nstd_flag(java.lang.String mon_nstd_flag)
	{
		this.mon_nstd_flag = mon_nstd_flag;
	}

 	protected java.lang.String mon_nstd_parent;


	/**
	 *  The name of the parent monomer of the nonstandard monomer,
	 *  if the nonstandard monomer represents a modification of a
	 *  standard monomer.
	 *  tyrosine
	 *  cytosine
	 */
	public java.lang.String getMon_nstd_parent() 
	{
		return mon_nstd_parent;
	}
 
	public void setMon_nstd_parent(java.lang.String mon_nstd_parent)
	{
		this.mon_nstd_parent = mon_nstd_parent;
	}

 	protected java.lang.String mon_nstd_parent_comp_id;


	/**
	 *  The identifier for the parent component of the nonstandard
	 *  component.
	 *  
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getMon_nstd_parent_comp_id() 
	{
		return mon_nstd_parent_comp_id;
	}
 
	public void setMon_nstd_parent_comp_id(java.lang.String mon_nstd_parent_comp_id)
	{
		this.mon_nstd_parent_comp_id = mon_nstd_parent_comp_id;
	}

 	protected java.lang.String name;


	/**
	 *  The full name of the component.
	 *  alanine
	 *  valine
	 *  adenine
	 *  cytosine
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.Integer number_atoms_all;


	/**
	 *  The total number of atoms in the component.
	 */
	public java.lang.Integer getNumber_atoms_all() 
	{
		return number_atoms_all;
	}
 
	public void setNumber_atoms_all(java.lang.Integer number_atoms_all)
	{
		this.number_atoms_all = number_atoms_all;
	}

 	protected java.lang.Integer number_atoms_nh;


	/**
	 *  The number of non-hydrogen atoms in the component.
	 */
	public java.lang.Integer getNumber_atoms_nh() 
	{
		return number_atoms_nh;
	}
 
	public void setNumber_atoms_nh(java.lang.Integer number_atoms_nh)
	{
		this.number_atoms_nh = number_atoms_nh;
	}

 	protected java.lang.String one_letter_code;


	/**
	 *  For standard polymer components, the one-letter code for
	 *  the component. If there is not a standard one-letter code
	 *  for this component, or if this is a non-polymer
	 *  component, the one-letter code should be given as 'X'.
	 *  This code may be preceded by a '+' character to indicate
	 *  that the component is a modification of a standard
	 *  component.
	 *  alanine or adenine
	 *  A
	 *  ambiguous asparagine/aspartic acid
	 *  B
	 *  arginine
	 *  R
	 *  asparagine
	 *  N
	 *  aspartic acid
	 *  D
	 *  cysteine or cystine or cytosine
	 *  C
	 *  glutamine
	 *  Q
	 *  glutamic acid
	 *  E
	 *  ambiguous glutamine/glutamic acid
	 *  Z
	 *  glycine or guanine
	 *  G
	 *  histidine
	 *  H
	 *  isoleucine
	 *  I
	 *  leucine
	 *  L
	 *  lysine
	 *  K
	 *  methionine
	 *  M
	 *  phenylalanine
	 *  F
	 *  proline
	 *  P
	 *  serine
	 *  S
	 *  threonine or thymine
	 *  T
	 *  tryptophan
	 *  W
	 *  tyrosine
	 *  Y
	 *  valine
	 *  V
	 *  uracil
	 *  U
	 *  water
	 *  O
	 *  other
	 *  X
	 */
	public java.lang.String getOne_letter_code() 
	{
		return one_letter_code;
	}
 
	public void setOne_letter_code(java.lang.String one_letter_code)
	{
		this.one_letter_code = one_letter_code;
	}

 	protected java.lang.String pdbx_ambiguous_flag;


	/**
	 *  A preliminary classification used by PDB to indicate
	 *  that the chemistry of this component while described
	 *  as clearly as possible is still ambiguous.  Software
	 *  tools may not be able to process this component
	 *  definition.
	 */
	public java.lang.String getPdbx_ambiguous_flag() 
	{
		return pdbx_ambiguous_flag;
	}
 
	public void setPdbx_ambiguous_flag(java.lang.String pdbx_ambiguous_flag)
	{
		this.pdbx_ambiguous_flag = pdbx_ambiguous_flag;
	}

 	protected java.lang.Integer pdbx_component_no;


	/**
	 *  A serial number used by PDB in the FORMUL record.
	 *  3
	 */
	public java.lang.Integer getPdbx_component_no() 
	{
		return pdbx_component_no;
	}
 
	public void setPdbx_component_no(java.lang.Integer pdbx_component_no)
	{
		this.pdbx_component_no = pdbx_component_no;
	}

 	protected java.lang.Integer pdbx_formal_charge;


	/**
	 *  The net integer charge assigned to this component. This is the
	 *  formal charge assignment normally found in chemical diagrams.
	 */
	public java.lang.Integer getPdbx_formal_charge() 
	{
		return pdbx_formal_charge;
	}
 
	public void setPdbx_formal_charge(java.lang.Integer pdbx_formal_charge)
	{
		this.pdbx_formal_charge = pdbx_formal_charge;
	}

 	protected java.lang.String pdbx_ideal_coordinates_details;


	/**
	 *  This data item identifies the source of the ideal coordinates in the
	 *  component definition.
	 */
	public java.lang.String getPdbx_ideal_coordinates_details() 
	{
		return pdbx_ideal_coordinates_details;
	}
 
	public void setPdbx_ideal_coordinates_details(java.lang.String pdbx_ideal_coordinates_details)
	{
		this.pdbx_ideal_coordinates_details = pdbx_ideal_coordinates_details;
	}

 	protected java.lang.String pdbx_ideal_coordinates_missing_flag;


	/**
	 *  This data item identifies if ideal coordinates are missing in this definition.
	 */
	public java.lang.String getPdbx_ideal_coordinates_missing_flag() 
	{
		return pdbx_ideal_coordinates_missing_flag;
	}
 
	public void setPdbx_ideal_coordinates_missing_flag(java.lang.String pdbx_ideal_coordinates_missing_flag)
	{
		this.pdbx_ideal_coordinates_missing_flag = pdbx_ideal_coordinates_missing_flag;
	}

 	protected java.util.Date pdbx_initial_date;


	/**
	 *  Date component was added to database.
	 */
	public java.util.Date getPdbx_initial_date() 
	{
		return pdbx_initial_date;
	}
 
	public void setPdbx_initial_date(java.util.Date pdbx_initial_date)
	{
		this.pdbx_initial_date = pdbx_initial_date;
	}

 	protected java.lang.String pdbx_model_coordinates_db_code;


	/**
	 *  This data item identifies the PDB database code from which the heavy
	 *  atom model coordinates were obtained.
	 */
	public java.lang.String getPdbx_model_coordinates_db_code() 
	{
		return pdbx_model_coordinates_db_code;
	}
 
	public void setPdbx_model_coordinates_db_code(java.lang.String pdbx_model_coordinates_db_code)
	{
		this.pdbx_model_coordinates_db_code = pdbx_model_coordinates_db_code;
	}

 	protected java.lang.String pdbx_model_coordinates_details;


	/**
	 *  This data item provides additional details about the model coordinates
	 *  in the component definition.
	 */
	public java.lang.String getPdbx_model_coordinates_details() 
	{
		return pdbx_model_coordinates_details;
	}
 
	public void setPdbx_model_coordinates_details(java.lang.String pdbx_model_coordinates_details)
	{
		this.pdbx_model_coordinates_details = pdbx_model_coordinates_details;
	}

 	protected java.lang.String pdbx_model_coordinates_missing_flag;


	/**
	 *  This data item identifies if model coordinates are missing in this definition.
	 */
	public java.lang.String getPdbx_model_coordinates_missing_flag() 
	{
		return pdbx_model_coordinates_missing_flag;
	}
 
	public void setPdbx_model_coordinates_missing_flag(java.lang.String pdbx_model_coordinates_missing_flag)
	{
		this.pdbx_model_coordinates_missing_flag = pdbx_model_coordinates_missing_flag;
	}

 	protected java.lang.String pdbx_modification_details;


	/**
	 *  For nonstandard components a text description
	 *  of modification of the parent component.
	 *  ATP
	 */
	public java.lang.String getPdbx_modification_details() 
	{
		return pdbx_modification_details;
	}
 
	public void setPdbx_modification_details(java.lang.String pdbx_modification_details)
	{
		this.pdbx_modification_details = pdbx_modification_details;
	}

 	protected java.util.Date pdbx_modified_date;


	/**
	 *  Date component was last modified.
	 */
	public java.util.Date getPdbx_modified_date() 
	{
		return pdbx_modified_date;
	}
 
	public void setPdbx_modified_date(java.util.Date pdbx_modified_date)
	{
		this.pdbx_modified_date = pdbx_modified_date;
	}

 	protected java.lang.String pdbx_release_status;


	/**
	 *  This data item holds the current release status for the component.
	 */
	public java.lang.String getPdbx_release_status() 
	{
		return pdbx_release_status;
	}
 
	public void setPdbx_release_status(java.lang.String pdbx_release_status)
	{
		this.pdbx_release_status = pdbx_release_status;
	}

 	protected java.lang.String pdbx_replaced_by;


	/**
	 *  Identifies the  attribute id in category chem_comp of the component that
	 *  has replaced this component.
	 *  q11
	 *  tvx
	 */
	public java.lang.String getPdbx_replaced_by() 
	{
		return pdbx_replaced_by;
	}
 
	public void setPdbx_replaced_by(java.lang.String pdbx_replaced_by)
	{
		this.pdbx_replaced_by = pdbx_replaced_by;
	}

 	protected java.lang.String pdbx_replaces;


	/**
	 *  Identifies the  attribute id's in category chem_comp of the components
	 *  which have been replaced by this component.
	 *  Multiple id codes should be separated by commas.
	 *  q11
	 *  tvx,atv
	 */
	public java.lang.String getPdbx_replaces() 
	{
		return pdbx_replaces;
	}
 
	public void setPdbx_replaces(java.lang.String pdbx_replaces)
	{
		this.pdbx_replaces = pdbx_replaces;
	}

 	protected java.lang.String pdbx_synonyms;


	/**
	 *  Synonym list for the component.
	 *  ATP
	 */
	public java.lang.String getPdbx_synonyms() 
	{
		return pdbx_synonyms;
	}
 
	public void setPdbx_synonyms(java.lang.String pdbx_synonyms)
	{
		this.pdbx_synonyms = pdbx_synonyms;
	}

 	protected java.lang.String pdbx_type;


	/**
	 *  A preliminary classification used by PDB.
	 */
	public java.lang.String getPdbx_type() 
	{
		return pdbx_type;
	}
 
	public void setPdbx_type(java.lang.String pdbx_type)
	{
		this.pdbx_type = pdbx_type;
	}

 	protected java.lang.String three_letter_code;


	/**
	 *  For standard polymer components, the three-letter code for
	 *  the component. If there is not a standard three-letter code
	 *  for this component, or if this is a non-polymer
	 *  component, the three-letter code should be given as 'UNK'.
	 *  This code may be preceded by a '+' character to indicate
	 *  that the component is a modification of a standard
	 *  component.
	 *  alanine
	 *  ALA
	 *  arginine
	 *  ARG
	 *  asparagine
	 *  ASN
	 *  aspartic acid
	 *  ASP
	 *  ambiguous asparagine/aspartic acid
	 *  ASX
	 *  cysteine
	 *  CYS
	 *  glutamine
	 *  GLN
	 *  glutamic acid
	 *  GLU
	 *  glycine
	 *  GLY
	 *  ambiguous glutamine/glutamic acid
	 *  GLX
	 *  histidine
	 *  HIS
	 *  isoleucine
	 *  ILE
	 *  leucine
	 *  LEU
	 *  lysine
	 *  LYS
	 *  methionine
	 *  MET
	 *  phenylalanine
	 *  PHE
	 *  proline
	 *  PRO
	 *  serine
	 *  SER
	 *  threonine
	 *  THR
	 *  tryptophan
	 *  TRP
	 *  tyrosine
	 *  TRY
	 *  valine
	 *  VAL
	 *  1-methyladenosine
	 *  1MA
	 *  5-methylcytosine
	 *  5MC
	 *  2(prime)-O-methylcytodine
	 *  OMC
	 *  1-methylguanosine
	 *  1MG
	 *  N(2)-methylguanosine
	 *  2MG
	 *  N(2)-dimethylguanosine
	 *  M2G
	 *  7-methylguanosine
	 *  7MG
	 *  2(prime)-O-methylguanosine
	 *  0MG
	 *  dihydrouridine
	 *  H2U
	 *  ribosylthymidine
	 *  5MU
	 *  pseudouridine
	 *  PSU
	 *  acetic acid
	 *  ACE
	 *  formic acid
	 *  FOR
	 *  water
	 *  HOH
	 *  other
	 *  UNK
	 */
	public java.lang.String getThree_letter_code() 
	{
		return three_letter_code;
	}
 
	public void setThree_letter_code(java.lang.String three_letter_code)
	{
		this.three_letter_code = three_letter_code;
	}

 	protected java.lang.String type;


	/**
	 *  For standard polymer components, the type of the monomer.
	 *  Note that monomers that will form polymers are of three types:
	 *  linking monomers, monomers with some type of N-terminal (or 5')
	 *  cap and monomers with some type of C-terminal (or 3') cap.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
