package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_ATOM category record details about
 *  the atoms in a chemical component. Specifying the atomic
 *  coordinates for the components in this category is an
 *  alternative to specifying the structure of the component
 *  via bonds, angles, planes etc. in the appropriate
 *  CHEM_COMP subcategories.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_atomCategory>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="N">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.20134</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.84658</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CA">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00000</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.00000</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="C">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.25029</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.88107</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="O">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-2.18525</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.66029</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>-0.78409</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CB">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00662</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-1.03603</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>1.11081</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CG">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.03254</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.49711</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>2.50951</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CD1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.15813</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.12084</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>3.13467</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CE1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.15720</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.38038</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>4.42732</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CZ">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.05385</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.51332</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>5.11032</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CE2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.26137</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.11613</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>4.50975</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="phe" atom_id="CD2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.23668</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.38351</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>3.20288</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="N">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>1.20134</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.84658</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CA">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.00000</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.00000</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="C">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-1.25029</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.88107</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.00000</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="O">
 *  <PDBx:type_symbol>O</PDBx:type_symbol>
 *  <PDBx:substruct_code>main</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-2.18525</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>0.66029</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>-0.78409</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CB">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>0.05260</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.99339</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>1.17429</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CG1">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-0.13288</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-0.31545</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>2.52668</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  <PDBx:chem_comp_atom comp_id="val" atom_id="CG2">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:substruct_code>side</PDBx:substruct_code>
 *  <PDBx:model_Cartn_x>-0.94265</PDBx:model_Cartn_x>
 *  <PDBx:model_Cartn_y>-2.12930</PDBx:model_Cartn_y>
 *  <PDBx:model_Cartn_z>0.99811</PDBx:model_Cartn_z>
 *  </PDBx:chem_comp_atom>
 *  </PDBx:chem_comp_atomCategory>
 * </pre>
 */
public class Chem_comp_atom 
{
		protected java.lang.String alt_atom_id;


	/**
	 *  An alternative identifier for the atom. This data item would be
	 *  used in cases where alternative nomenclatures exist for labelling
	 *  atoms in a group.
	 */
	public java.lang.String getAlt_atom_id() 
	{
		return alt_atom_id;
	}
 
	public void setAlt_atom_id(java.lang.String alt_atom_id)
	{
		this.alt_atom_id = alt_atom_id;
	}

 	protected java.lang.String atom_id;


	/**
	 *  The value of  attribute atom_id in category chem_comp_atom must uniquely identify
	 *  each atom in each monomer in the CHEM_COMP_ATOM list.
	 *  
	 *  The atom identifiers need not be unique over all atoms in the
	 *  data block; they need only be unique for each atom in a
	 *  component.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.Integer charge;


	/**
	 *  The net integer charge assigned to this atom. This is the
	 *  formal charge assignment normally found in chemical diagrams.
	 *  for an ammonium nitrogen
	 *  1
	 *  for a chloride ion
	 *  -1
	 */
	public java.lang.Integer getCharge() 
	{
		return charge;
	}
 
	public void setCharge(java.lang.Integer charge)
	{
		this.charge = charge;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.Float model_Cartn_x;


	/**
	 *  The x component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms. The choice of
	 *  reference axis frame for the coordinates is arbitrary.
	 *  
	 *  The set of coordinates input for the entity here is intended to
	 *  correspond to the atomic model used to generate restraints for
	 *  structure refinement, not to atom sites in the ATOM_SITE
	 *  list.
	 */
	public java.lang.Float getModel_Cartn_x() 
	{
		return model_Cartn_x;
	}
 
	public void setModel_Cartn_x(java.lang.Float model_Cartn_x)
	{
		this.model_Cartn_x = model_Cartn_x;
	}

 	protected java.lang.Float model_Cartn_x_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute model_Cartn_x in category chem_comp_atom.
	 */
	public java.lang.Float getModel_Cartn_x_esd() 
	{
		return model_Cartn_x_esd;
	}
 
	public void setModel_Cartn_x_esd(java.lang.Float model_Cartn_x_esd)
	{
		this.model_Cartn_x_esd = model_Cartn_x_esd;
	}

 	protected java.lang.Float model_Cartn_y;


	/**
	 *  The y component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms. The choice of
	 *  reference axis frame for the coordinates is arbitrary.
	 *  
	 *  The set of coordinates input for the entity here is intended to
	 *  correspond to the atomic model used to generate restraints for
	 *  structure refinement, not to atom sites in the ATOM_SITE
	 *  list.
	 */
	public java.lang.Float getModel_Cartn_y() 
	{
		return model_Cartn_y;
	}
 
	public void setModel_Cartn_y(java.lang.Float model_Cartn_y)
	{
		this.model_Cartn_y = model_Cartn_y;
	}

 	protected java.lang.Float model_Cartn_y_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute model_Cartn_y in category chem_comp_atom.
	 */
	public java.lang.Float getModel_Cartn_y_esd() 
	{
		return model_Cartn_y_esd;
	}
 
	public void setModel_Cartn_y_esd(java.lang.Float model_Cartn_y_esd)
	{
		this.model_Cartn_y_esd = model_Cartn_y_esd;
	}

 	protected java.lang.Float model_Cartn_z;


	/**
	 *  The z component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms. The choice of
	 *  reference axis frame for the coordinates is arbitrary.
	 *  
	 *  The set of coordinates input for the entity here is intended to
	 *  correspond to the atomic model used to generate restraints for
	 *  structure refinement, not to atom sites in the ATOM_SITE
	 *  list.
	 */
	public java.lang.Float getModel_Cartn_z() 
	{
		return model_Cartn_z;
	}
 
	public void setModel_Cartn_z(java.lang.Float model_Cartn_z)
	{
		this.model_Cartn_z = model_Cartn_z;
	}

 	protected java.lang.Float model_Cartn_z_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute model_Cartn_z in category chem_comp_atom.
	 */
	public java.lang.Float getModel_Cartn_z_esd() 
	{
		return model_Cartn_z_esd;
	}
 
	public void setModel_Cartn_z_esd(java.lang.Float model_Cartn_z_esd)
	{
		this.model_Cartn_z_esd = model_Cartn_z_esd;
	}

 	protected java.lang.Float partial_charge;


	/**
	 *  The partial charge assigned to this atom.
	 */
	public java.lang.Float getPartial_charge() 
	{
		return partial_charge;
	}
 
	public void setPartial_charge(java.lang.Float partial_charge)
	{
		this.partial_charge = partial_charge;
	}

 	protected java.lang.Integer pdbx_align;


	/**
	 *  Atom name alignment offset in PDB atom field.
	 */
	public java.lang.Integer getPdbx_align() 
	{
		return pdbx_align;
	}
 
	public void setPdbx_align(java.lang.Integer pdbx_align)
	{
		this.pdbx_align = pdbx_align;
	}

 	protected java.lang.String pdbx_alt_atom_id;


	/**
	 *  An alternative identifier for the atom. This data item would be
	 *  used in cases where alternative nomenclatures exist for labelling
	 *  atoms in a group.
	 */
	public java.lang.String getPdbx_alt_atom_id() 
	{
		return pdbx_alt_atom_id;
	}
 
	public void setPdbx_alt_atom_id(java.lang.String pdbx_alt_atom_id)
	{
		this.pdbx_alt_atom_id = pdbx_alt_atom_id;
	}

 	protected java.lang.String pdbx_alt_comp_id;


	/**
	 *  An alternative identifier for the atom. This data item would be
	 *  used in cases where alternative nomenclatures exist for labelling
	 *  atoms in a group.
	 */
	public java.lang.String getPdbx_alt_comp_id() 
	{
		return pdbx_alt_comp_id;
	}
 
	public void setPdbx_alt_comp_id(java.lang.String pdbx_alt_comp_id)
	{
		this.pdbx_alt_comp_id = pdbx_alt_comp_id;
	}

 	protected java.lang.String pdbx_aromatic_flag;


	/**
	 *  A flag indicating an aromatic atom.
	 */
	public java.lang.String getPdbx_aromatic_flag() 
	{
		return pdbx_aromatic_flag;
	}
 
	public void setPdbx_aromatic_flag(java.lang.String pdbx_aromatic_flag)
	{
		this.pdbx_aromatic_flag = pdbx_aromatic_flag;
	}

 	protected java.lang.String pdbx_leaving_atom_flag;


	/**
	 *  A flag indicating a leaving atom.
	 */
	public java.lang.String getPdbx_leaving_atom_flag() 
	{
		return pdbx_leaving_atom_flag;
	}
 
	public void setPdbx_leaving_atom_flag(java.lang.String pdbx_leaving_atom_flag)
	{
		this.pdbx_leaving_atom_flag = pdbx_leaving_atom_flag;
	}

 	protected java.lang.Float pdbx_model_Cartn_x_ideal;


	/**
	 *  An alternative x component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms.
	 */
	public java.lang.Float getPdbx_model_Cartn_x_ideal() 
	{
		return pdbx_model_Cartn_x_ideal;
	}
 
	public void setPdbx_model_Cartn_x_ideal(java.lang.Float pdbx_model_Cartn_x_ideal)
	{
		this.pdbx_model_Cartn_x_ideal = pdbx_model_Cartn_x_ideal;
	}

 	protected java.lang.Float pdbx_model_Cartn_y_ideal;


	/**
	 *  An alternative y component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms.
	 */
	public java.lang.Float getPdbx_model_Cartn_y_ideal() 
	{
		return pdbx_model_Cartn_y_ideal;
	}
 
	public void setPdbx_model_Cartn_y_ideal(java.lang.Float pdbx_model_Cartn_y_ideal)
	{
		this.pdbx_model_Cartn_y_ideal = pdbx_model_Cartn_y_ideal;
	}

 	protected java.lang.Float pdbx_model_Cartn_z_ideal;


	/**
	 *  An alternative z component of the coordinates for this atom in this
	 *  component specified as orthogonal angstroms.
	 */
	public java.lang.Float getPdbx_model_Cartn_z_ideal() 
	{
		return pdbx_model_Cartn_z_ideal;
	}
 
	public void setPdbx_model_Cartn_z_ideal(java.lang.Float pdbx_model_Cartn_z_ideal)
	{
		this.pdbx_model_Cartn_z_ideal = pdbx_model_Cartn_z_ideal;
	}

 	protected java.lang.Integer pdbx_ordinal;


	/**
	 *  Ordinal index for the component atom list.
	 */
	public java.lang.Integer getPdbx_ordinal() 
	{
		return pdbx_ordinal;
	}
 
	public void setPdbx_ordinal(java.lang.Integer pdbx_ordinal)
	{
		this.pdbx_ordinal = pdbx_ordinal;
	}

 	protected java.lang.String pdbx_stereo_config;


	/**
	 *  The chiral configuration of the atom that is a chiral center.
	 */
	public java.lang.String getPdbx_stereo_config() 
	{
		return pdbx_stereo_config;
	}
 
	public void setPdbx_stereo_config(java.lang.String pdbx_stereo_config)
	{
		this.pdbx_stereo_config = pdbx_stereo_config;
	}

 	protected java.lang.String substruct_code;


	/**
	 *  This data item assigns the atom to a substructure of the
	 *  component, if appropriate.
	 */
	public java.lang.String getSubstruct_code() 
	{
		return substruct_code;
	}
 
	public void setSubstruct_code(java.lang.String substruct_code)
	{
		this.substruct_code = substruct_code;
	}

 	protected java.lang.String type_symbol;


	/**
	 *  This data item is a pointer to  attribute symbol in category atom_type in the
	 *  ATOM_TYPE category.
	 */
	public java.lang.String getType_symbol() 
	{
		return type_symbol;
	}
 
	public void setType_symbol(java.lang.String type_symbol)
	{
		this.type_symbol = type_symbol;
	}

 }
