package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_BOND category record details about
 *  the bonds between atoms in a chemical component. Target values
 *  may be specified as bond orders, as a distance between the two
 *  atoms, or both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_bondCategory>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_order>doub</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CB" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CB" atom_id_2="CG">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CG" atom_id_2="CD1">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CD1" atom_id_2="CE1">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CE1" atom_id_2="CZ">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CZ" atom_id_2="CE2">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CE2" atom_id_2="CD2">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="phe" atom_id_1="CD2" atom_id_2="CG">
 *  <PDBx:value_order>arom</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_order>doub</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CA">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CG1">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  <PDBx:chem_comp_bond comp_id="val" atom_id_1="CB" atom_id_2="CG2">
 *  <PDBx:value_order>sing</PDBx:value_order>
 *  </PDBx:chem_comp_bond>
 *  </PDBx:chem_comp_bondCategory>
 * </pre>
 */
public class Chem_comp_bond 
{
		protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the two atoms that define the bond.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the two atoms that define the bond.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String pdbx_aromatic_flag;


	/**
	 *  A flag indicating an aromatic bond.
	 */
	public java.lang.String getPdbx_aromatic_flag() 
	{
		return pdbx_aromatic_flag;
	}
 
	public void setPdbx_aromatic_flag(java.lang.String pdbx_aromatic_flag)
	{
		this.pdbx_aromatic_flag = pdbx_aromatic_flag;
	}

 	protected java.lang.Integer pdbx_ordinal;


	/**
	 *  Ordinal index for the component bond list.
	 */
	public java.lang.Integer getPdbx_ordinal() 
	{
		return pdbx_ordinal;
	}
 
	public void setPdbx_ordinal(java.lang.Integer pdbx_ordinal)
	{
		this.pdbx_ordinal = pdbx_ordinal;
	}

 	protected java.lang.String pdbx_stereo_config;


	/**
	 *  Stereochemical configuration across a double bond.
	 */
	public java.lang.String getPdbx_stereo_config() 
	{
		return pdbx_stereo_config;
	}
 
	public void setPdbx_stereo_config(java.lang.String pdbx_stereo_config)
	{
		this.pdbx_stereo_config = pdbx_stereo_config;
	}

 	protected java.lang.Float value_dist;


	/**
	 *  The value that should be taken as the target for the chemical
	 *  bond associated with the specified atoms, expressed as a
	 *  distance.
	 */
	public java.lang.Float getValue_dist() 
	{
		return value_dist;
	}
 
	public void setValue_dist(java.lang.Float value_dist)
	{
		this.value_dist = value_dist;
	}

 	protected java.lang.Float value_dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_dist in category chem_comp_bond.
	 */
	public java.lang.Float getValue_dist_esd() 
	{
		return value_dist_esd;
	}
 
	public void setValue_dist_esd(java.lang.Float value_dist_esd)
	{
		this.value_dist_esd = value_dist_esd;
	}

 	protected java.lang.String value_order;


	/**
	 *  The value that should be taken as the target for the chemical
	 *  bond associated with the specified atoms, expressed as a bond
	 *  order.
	 */
	public java.lang.String getValue_order() 
	{
		return value_order;
	}
 
	public void setValue_order(java.lang.String value_order)
	{
		this.value_order = value_order;
	}

 }
