package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_PLANE category provide identifiers
 *  for the planes in a chemical component.  The atoms in the plane
 *  are specified in the CHEM_COMP_PLANE_ATOM category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_planeCategory>
 *  <PDBx:chem_comp_plane comp_id="phe" id="phe1"></PDBx:chem_comp_plane>
 *  </PDBx:chem_comp_planeCategory>
 * </pre>
 */
public class Chem_comp_plane 
{
		protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category chem_comp_plane must uniquely identify a record
	 *  in the CHEM_COMP_PLANE list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer number_atoms_all;


	/**
	 *  The total number of atoms in the plane.
	 */
	public java.lang.Integer getNumber_atoms_all() 
	{
		return number_atoms_all;
	}
 
	public void setNumber_atoms_all(java.lang.Integer number_atoms_all)
	{
		this.number_atoms_all = number_atoms_all;
	}

 	protected java.lang.Integer number_atoms_nh;


	/**
	 *  The number of non-hydrogen atoms in the plane.
	 */
	public java.lang.Integer getNumber_atoms_nh() 
	{
		return number_atoms_nh;
	}
 
	public void setNumber_atoms_nh(java.lang.Integer number_atoms_nh)
	{
		this.number_atoms_nh = number_atoms_nh;
	}

 }
