package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_PLANE_ATOM category enumerate the
 *  atoms in a plane within a chemical component.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_plane_atomCategory>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CB"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CG"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CD1"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CE1"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CZ"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CE2"></PDBx:chem_comp_plane_atom>
 *  <PDBx:chem_comp_plane_atom plane_id="phe1" comp_id="phe" atom_id="CD2"></PDBx:chem_comp_plane_atom>
 *  </PDBx:chem_comp_plane_atomCategory>
 * </pre>
 */
public class Chem_comp_plane_atom 
{
		protected java.lang.String atom_id;


	/**
	 *  The ID of an atom involved in the plane.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.Float dist_esd;


	/**
	 *  This data item is the standard deviation of the
	 *  out-of-plane distance for this atom.
	 */
	public java.lang.Float getDist_esd() 
	{
		return dist_esd;
	}
 
	public void setDist_esd(java.lang.Float dist_esd)
	{
		this.dist_esd = dist_esd;
	}

 	protected java.lang.String plane_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp_plane in the
	 *  CHEM_COMP_PLANE category.
	 */
	public java.lang.String getPlane_id() 
	{
		return plane_id;
	}
 
	public void setPlane_id(java.lang.String plane_id)
	{
		this.plane_id = plane_id;
	}

 }
