package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_TOR_VALUE category record details
 *  about the target values for the torsion angles enumerated in the
 *  CHEM_COMP_TOR list. Target values may be specified as angles
 *  in degrees, as a distance between the first and fourth atoms, or
 *  both.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_tor_valueCategory>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>-60.0</PDBx:angle>
 *  <PDBx:dist>2.88</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.72</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi1" comp_id="phe">
 *  <PDBx:angle>60.0</PDBx:angle>
 *  <PDBx:dist>2.88</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi2" comp_id="phe">
 *  <PDBx:angle>90.0</PDBx:angle>
 *  <PDBx:dist>3.34</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_chi2" comp_id="phe">
 *  <PDBx:angle>-90.0</PDBx:angle>
 *  <PDBx:dist>3.34</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring1" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.75</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring2" comp_id="phe">
 *  <PDBx:angle>180.0</PDBx:angle>
 *  <PDBx:dist>3.75</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring3" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring4" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  <PDBx:chem_comp_tor_value tor_id="phe_ring5" comp_id="phe">
 *  <PDBx:angle>0.0</PDBx:angle>
 *  <PDBx:dist>2.80</PDBx:dist>
 *  </PDBx:chem_comp_tor_value>
 *  </PDBx:chem_comp_tor_valueCategory>
 * </pre>
 */
public class Chem_comp_tor_value 
{
		protected java.lang.Float angle;


	/**
	 *  A value that should be taken as a potential target value for the
	 *  torsion angle associated with the specified atoms, expressed in
	 *  degrees.
	 */
	public java.lang.Float getAngle() 
	{
		return angle;
	}
 
	public void setAngle(java.lang.Float angle)
	{
		this.angle = angle;
	}

 	protected java.lang.Float angle_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle in category chem_comp_tor_value.
	 */
	public java.lang.Float getAngle_esd() 
	{
		return angle_esd;
	}
 
	public void setAngle_esd(java.lang.Float angle_esd)
	{
		this.angle_esd = angle_esd;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute comp_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.Float dist;


	/**
	 *  A value that should be taken as a potential target value for the
	 *  torsion angle associated with the specified atoms, expressed as
	 *  the distance between the atoms specified by
	 *  _chem_comp_tor.atom_id_1 and _chem_comp_tor.atom_id_4 in the
	 *  referenced record in the CHEM_COMP_TOR list. Note that the
	 *  torsion angle cannot be fully specified by a distance (for
	 *  instance, a torsion angle of -60  degree will yield the same
	 *  distance as a 60 degree angle). However, the distance
	 *  specification can be useful for refinement in situations
	 *  in which the angle is already close to the desired value.
	 */
	public java.lang.Float getDist() 
	{
		return dist;
	}
 
	public void setDist(java.lang.Float dist)
	{
		this.dist = dist;
	}

 	protected java.lang.Float dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute dist in category chem_comp_tor_value.
	 */
	public java.lang.Float getDist_esd() 
	{
		return dist_esd;
	}
 
	public void setDist_esd(java.lang.Float dist_esd)
	{
		this.dist_esd = dist_esd;
	}

 	protected java.lang.String tor_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp_tor in the
	 *  CHEM_COMP_TOR category.
	 */
	public java.lang.String getTor_id() 
	{
		return tor_id;
	}
 
	public void setTor_id(java.lang.String tor_id)
	{
		this.tor_id = tor_id;
	}

 }
