package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_BOND category record details about
 *  bonds in a link between components in the chemical structure.
 *  
 * <pre>
 *  Example 1 - Engh & Huber parameters [Acta Cryst. (1991), A47,
 *  392-400] as interpreted by J. P. Priestle (1995). Consistent
 *  Stereochemical Dictionaries for Refinement and Model
 *  Building. CCP4 Daresbury Study Weekend,
 *  DL-CONF-95-001, ISSN 1358-6254. Warrington: Daresbury
 *  Laboratory.
 *  <PDBx:chem_link_bondCategory>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="N" atom_id_2="CA">
 *  <PDBx:value_dist>1.458</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.019</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C">
 *  <PDBx:value_dist>1.525</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.021</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="C" atom_id_2="N">
 *  <PDBx:value_dist>1.329</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.014</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>2</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  <PDBx:chem_link_bond link_id="PEPTIDE" atom_id_1="C" atom_id_2="O">
 *  <PDBx:value_dist>1.231</PDBx:value_dist>
 *  <PDBx:value_dist_esd>0.020</PDBx:value_dist_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  </PDBx:chem_link_bond>
 *  </PDBx:chem_link_bondCategory>
 * </pre>
 */
public class Chem_link_bond 
{
		protected java.lang.String atom_1_comp_id;


	/**
	 *  This data item indicates whether atom 1 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_1_comp_id() 
	{
		return atom_1_comp_id;
	}
 
	public void setAtom_1_comp_id(java.lang.String atom_1_comp_id)
	{
		this.atom_1_comp_id = atom_1_comp_id;
	}

 	protected java.lang.String atom_2_comp_id;


	/**
	 *  This data item indicates whether atom 2 is found in the first
	 *  or the second of the two chemical components connected by
	 *  the link.
	 */
	public java.lang.String getAtom_2_comp_id() 
	{
		return atom_2_comp_id;
	}
 
	public void setAtom_2_comp_id(java.lang.String atom_2_comp_id)
	{
		this.atom_2_comp_id = atom_2_comp_id;
	}

 	protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the two atoms that define the bond.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the
	 *  linkage sense.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the two atoms that define the bond.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific component, it is not a child in the linkage sense.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String link_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link in the CHEM_LINK
	 *  category.
	 */
	public java.lang.String getLink_id() 
	{
		return link_id;
	}
 
	public void setLink_id(java.lang.String link_id)
	{
		this.link_id = link_id;
	}

 	protected java.lang.Float value_dist;


	/**
	 *  The value that should be taken as the target for the chemical
	 *  bond associated with the specified atoms, expressed as a
	 *  distance.
	 */
	public java.lang.Float getValue_dist() 
	{
		return value_dist;
	}
 
	public void setValue_dist(java.lang.Float value_dist)
	{
		this.value_dist = value_dist;
	}

 	protected java.lang.Float value_dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_dist in category chem_link_bond.
	 */
	public java.lang.Float getValue_dist_esd() 
	{
		return value_dist_esd;
	}
 
	public void setValue_dist_esd(java.lang.Float value_dist_esd)
	{
		this.value_dist_esd = value_dist_esd;
	}

 	protected java.lang.String value_order;


	/**
	 *  The value that should be taken as the target for the chemical
	 *  bond associated with the specified atoms, expressed as a bond
	 *  order.
	 */
	public java.lang.String getValue_order() 
	{
		return value_order;
	}
 
	public void setValue_order(java.lang.String value_order)
	{
		this.value_order = value_order;
	}

 }
