package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_CHIR category provide details about
 *  the chiral centres in a link between two chemical components.
 *  The atoms bonded to the chiral atom are specified in the
 *  CHEM_LINK_CHIR_ATOM category.
 */
public class Chem_link_chir 
{
		protected java.lang.String atom_comp_id;


	/**
	 *  This data item indicates whether the chiral atom is found in the
	 *  first or the second of the two components connected by the
	 *  link.
	 */
	public java.lang.String getAtom_comp_id() 
	{
		return atom_comp_id;
	}
 
	public void setAtom_comp_id(java.lang.String atom_comp_id)
	{
		this.atom_comp_id = atom_comp_id;
	}

 	protected java.lang.String atom_config;


	/**
	 *  The chiral configuration of the atom that is a chiral centre.
	 */
	public java.lang.String getAtom_config() 
	{
		return atom_config;
	}
 
	public void setAtom_config(java.lang.String atom_config)
	{
		this.atom_config = atom_config;
	}

 	protected java.lang.String atom_id;


	/**
	 *  The ID of the atom that is a chiral centre.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category chem_link_chir must uniquely identify a record
	 *  in the CHEM_LINK_CHIR list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String link_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link in the CHEM_LINK
	 *  category.
	 */
	public java.lang.String getLink_id() 
	{
		return link_id;
	}
 
	public void setLink_id(java.lang.String link_id)
	{
		this.link_id = link_id;
	}

 	protected java.lang.Integer number_atoms_all;


	/**
	 *  The total number of atoms bonded to the atom specified by
	 *  attribute atom_id in category chem_link_chir.
	 */
	public java.lang.Integer getNumber_atoms_all() 
	{
		return number_atoms_all;
	}
 
	public void setNumber_atoms_all(java.lang.Integer number_atoms_all)
	{
		this.number_atoms_all = number_atoms_all;
	}

 	protected java.lang.Integer number_atoms_nh;


	/**
	 *  The number of non-hydrogen atoms bonded to the atom specified by
	 *  attribute atom_id in category chem_link_chir.
	 */
	public java.lang.Integer getNumber_atoms_nh() 
	{
		return number_atoms_nh;
	}
 
	public void setNumber_atoms_nh(java.lang.Integer number_atoms_nh)
	{
		this.number_atoms_nh = number_atoms_nh;
	}

 	protected java.lang.String volume_flag;


	/**
	 *  A flag to indicate whether a chiral volume should match the
	 *  standard value in both magnitude and sign, or in magnitude only.
	 */
	public java.lang.String getVolume_flag() 
	{
		return volume_flag;
	}
 
	public void setVolume_flag(java.lang.String volume_flag)
	{
		this.volume_flag = volume_flag;
	}

 	protected java.lang.Float volume_three;


	/**
	 *  The chiral volume, V(c), for chiral centres that involve a chiral
	 *  atom bonded to three non-hydrogen atoms and one hydrogen atom.
	 *  
	 *  V~c~ = V1 * (V2 X V3)
	 *  
	 *  V1 = the vector distance from the atom specified by
	 *  attribute atom_id in category chem_link_chir to the first atom in the
	 *  CHEM_LINK_CHIR_ATOM list
	 *  V2 = the vector distance from the atom specified by
	 *  attribute atom_id in category chem_link_chir to the second atom in the
	 *  CHEM_LINK_CHIR_ATOM list
	 *  V3 = the vector distance from the atom specified by
	 *  attribute atom_id in category chem_link_chir to the third atom in the
	 *  CHEM_LINK_CHIR_ATOM list
	 *  *  = the vector dot product
	 *  X  = the vector cross product
	 */
	public java.lang.Float getVolume_three() 
	{
		return volume_three;
	}
 
	public void setVolume_three(java.lang.Float volume_three)
	{
		this.volume_three = volume_three;
	}

 	protected java.lang.Float volume_three_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute volume_three in category chem_link_chir.
	 */
	public java.lang.Float getVolume_three_esd() 
	{
		return volume_three_esd;
	}
 
	public void setVolume_three_esd(java.lang.Float volume_three_esd)
	{
		this.volume_three_esd = volume_three_esd;
	}

 }
