package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_CHIR_ATOM category enumerate the
 *  atoms bonded to a chiral atom in a link between two
 *  chemical components.
 */
public class Chem_link_chir_atom 
{
		protected java.lang.String atom_comp_id;


	/**
	 *  This data item indicates whether the atom bonded to a chiral
	 *  atom is found in the first or the second of the two components
	 *  connected by the link.
	 */
	public java.lang.String getAtom_comp_id() 
	{
		return atom_comp_id;
	}
 
	public void setAtom_comp_id(java.lang.String atom_comp_id)
	{
		this.atom_comp_id = atom_comp_id;
	}

 	protected java.lang.String atom_id;


	/**
	 *  The ID of an atom bonded to the chiral atom.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.String chir_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link_chir in the
	 *  CHEM_LINK_CHIR category.
	 */
	public java.lang.String getChir_id() 
	{
		return chir_id;
	}
 
	public void setChir_id(java.lang.String chir_id)
	{
		this.chir_id = chir_id;
	}

 	protected java.lang.Float dev;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of the position of this atom from the plane defined by
	 *  all of the atoms in the plane.
	 */
	public java.lang.Float getDev() 
	{
		return dev;
	}
 
	public void setDev(java.lang.Float dev)
	{
		this.dev = dev;
	}

 }
