package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_TOR_VALUE category record details
 *  about the target values for the torsion angles enumerated in the
 *  CHEM_LINK_TOR list. Target values may be specified as angles
 *  in degrees, as a distance between the first and fourth atoms, or
 *  both.
 */
public class Chem_link_tor_value 
{
		protected java.lang.Float angle;


	/**
	 *  A value that should be taken as a potential target value for the
	 *  torsion angle associated with the specified atoms, expressed in
	 *  degrees.
	 */
	public java.lang.Float getAngle() 
	{
		return angle;
	}
 
	public void setAngle(java.lang.Float angle)
	{
		this.angle = angle;
	}

 	protected java.lang.Float angle_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle in category chem_link_tor_value.
	 */
	public java.lang.Float getAngle_esd() 
	{
		return angle_esd;
	}
 
	public void setAngle_esd(java.lang.Float angle_esd)
	{
		this.angle_esd = angle_esd;
	}

 	protected java.lang.Float dist;


	/**
	 *  A value that should be taken as a potential target value for the
	 *  torsion angle associated with the specified atoms, expressed as
	 *  the distance between the atoms specified by
	 *  _chem_link_tor.atom_id_1 and _chem_link_tor.atom_id_4 in the
	 *  referenced record in the CHEM_LINK_TOR list. Note that the
	 *  torsion angle cannot be fully specified by a distance (for
	 *  instance, a torsion angle of -60 degree will yield the same
	 *  distance as a 60 degree angle). However, the distance
	 *  specification can be useful for refinement in situations in
	 *  which the angle is already close to the desired value.
	 */
	public java.lang.Float getDist() 
	{
		return dist;
	}
 
	public void setDist(java.lang.Float dist)
	{
		this.dist = dist;
	}

 	protected java.lang.Float dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute dist in category chem_link_tor_value.
	 */
	public java.lang.Float getDist_esd() 
	{
		return dist_esd;
	}
 
	public void setDist_esd(java.lang.Float dist_esd)
	{
		this.dist_esd = dist_esd;
	}

 	protected java.lang.String tor_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link_tor in the
	 *  CHEM_LINK_TOR category.
	 */
	public java.lang.String getTor_id() 
	{
		return tor_id;
	}
 
	public void setTor_id(java.lang.String tor_id)
	{
		this.tor_id = tor_id;
	}

 }
