package org.pdb.beans;

/**
 *  Data items in the CHEMICAL category would not in general be
 *  used in a macromolecular CIF. See instead the ENTITY data
 *  items.
 *  
 *  Data items in the CHEMICAL category record details about the
 *  composition and chemical properties of the compounds. The
 *  formula data items must agree with those that specify the
 *  density, unit-cell and Z values.
 *  
 * <pre>
 *  Example 1 - based on data set 9597gaus of Alyea, Ferguson & Kannan
 *  [Acta Cryst. (1996), C52, 765-767].
 *  <PDBx:chemicalCategory>
 *  <PDBx:chemical entry_id="9597gaus">
 *  <PDBx:name_systematic>trans-bis(tricyclohexylphosphine)tetracarbonylmolybdenum(0)</PDBx:name_systematic>
 *  </PDBx:chemical>
 *  </PDBx:chemicalCategory>
 * </pre>
 */
public class Chemical 
{
		protected java.lang.String absolute_configuration;


	/**
	 *  Necessary conditions for the assignment of
	 *  attribute absolute_configuration in category chemical are given by H. D. Flack and
	 *  G. Bernardinelli (1999, 2000).
	 *  
	 *  Ref: Flack, H. D. & Bernardinelli, G. (1999). Acta Cryst. A55,
	 *  908-915. (http://www.iucr.org/paper?sh0129)
	 *  Flack, H. D. & Bernardinelli, G. (2000). J. Appl. Cryst.
	 *  33, 1143-1148. (http://www.iucr.org/paper?ks0021)
	 */
	public java.lang.String getAbsolute_configuration() 
	{
		return absolute_configuration;
	}
 
	public void setAbsolute_configuration(java.lang.String absolute_configuration)
	{
		this.absolute_configuration = absolute_configuration;
	}

 	protected java.lang.String compound_source;


	/**
	 *  Description of the source of the compound under study, or of the
	 *  parent  molecule if a simple derivative is studied. This includes
	 *  the place of discovery for minerals or the actual source of a
	 *  natural product.
	 *  From Norilsk (USSR)
	 *  Extracted from the bark of Cinchona Naturalis
	 */
	public java.lang.String getCompound_source() 
	{
		return compound_source;
	}
 
	public void setCompound_source(java.lang.String compound_source)
	{
		this.compound_source = compound_source;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Float melting_point;


	/**
	 *  The temperature in kelvins at which the crystalline solid changes
	 *  to a liquid.
	 */
	public java.lang.Float getMelting_point() 
	{
		return melting_point;
	}
 
	public void setMelting_point(java.lang.Float melting_point)
	{
		this.melting_point = melting_point;
	}

 	protected java.lang.Float melting_point_gt;


	/**
	 *  A temperature in kelvins above
	 *  which the melting point (the temperature at which the
	 *  crystalline solid changes to a liquid) lies.
	 *  _chemical.melting_point_gt and _chemical.melting_point_lt
	 *  allow a range of temperatures to be given.
	 *  
	 *  attribute melting_point in category chemical should always be used in preference
	 *  to these two items whenever possible.
	 */
	public java.lang.Float getMelting_point_gt() 
	{
		return melting_point_gt;
	}
 
	public void setMelting_point_gt(java.lang.Float melting_point_gt)
	{
		this.melting_point_gt = melting_point_gt;
	}

 	protected java.lang.Float melting_point_lt;


	/**
	 *  A temperature in kelvins below which the melting point (the
	 *  temperature at which the crystalline solid changes to a liquid)
	 *  lies. _chemical.melting_point_gt and _chemical.melting_point_lt
	 *  allow a range of temperatures to be given.
	 *  
	 *  attribute melting_point in category chemical should always be used in preference
	 *  to these two items whenever possible.
	 */
	public java.lang.Float getMelting_point_lt() 
	{
		return melting_point_lt;
	}
 
	public void setMelting_point_lt(java.lang.Float melting_point_lt)
	{
		this.melting_point_lt = melting_point_lt;
	}

 	protected java.lang.String name_common;


	/**
	 *  Trivial name by which the compound is commonly known.
	 *  1-bromoestradiol
	 */
	public java.lang.String getName_common() 
	{
		return name_common;
	}
 
	public void setName_common(java.lang.String name_common)
	{
		this.name_common = name_common;
	}

 	protected java.lang.String name_mineral;


	/**
	 *  Mineral name accepted by the International Mineralogical
	 *  Association. Use only for natural minerals. See also
	 *  attribute compound_source in category chemical.
	 *  chalcopyrite
	 */
	public java.lang.String getName_mineral() 
	{
		return name_mineral;
	}
 
	public void setName_mineral(java.lang.String name_mineral)
	{
		this.name_mineral = name_mineral;
	}

 	protected java.lang.String name_structure_type;


	/**
	 *  Commonly used structure-type name. Usually only applied to
	 *  minerals or inorganic compounds.
	 *  perovskite
	 *  sphalerite
	 *  A15
	 */
	public java.lang.String getName_structure_type() 
	{
		return name_structure_type;
	}
 
	public void setName_structure_type(java.lang.String name_structure_type)
	{
		this.name_structure_type = name_structure_type;
	}

 	protected java.lang.String name_systematic;


	/**
	 *  IUPAC or Chemical Abstracts full name of the compound.
	 *  1-bromoestra-1,3,5(10)-triene-3,17\b-diol
	 */
	public java.lang.String getName_systematic() 
	{
		return name_systematic;
	}
 
	public void setName_systematic(java.lang.String name_systematic)
	{
		this.name_systematic = name_systematic;
	}

 	protected java.lang.String optical_rotation;


	/**
	 *  The optical rotation in solution of the compound is
	 *  specified in the following format:
	 *  '[\a]^TEMP^~WAVE~ = SORT (c = CONC, SOLV)'
	 *  where:
	 *  TEMP is the temperature of the measurement in degrees
	 *  Celsius,
	 *  WAVE is an indication of the wavelength of the light
	 *  used for the measurement,
	 *  CONC is the concentration of the solution given as the
	 *  mass of the substance in g in 100 ml of solution,
	 *  SORT is the signed value (preceded by a + or a - sign)
	 *  of 100.\a/(l.c), where \a is the signed optical
	 *  rotation in degrees measured in a cell of length l in
	 *  dm and c is the value of CONC as defined above, and
	 *  SOLV is the chemical formula of the solvent.
	 *  [\a]^25^~D~ = +108 (c = 3.42, CHCl~3~)
	 */
	public java.lang.String getOptical_rotation() 
	{
		return optical_rotation;
	}
 
	public void setOptical_rotation(java.lang.String optical_rotation)
	{
		this.optical_rotation = optical_rotation;
	}

 	protected java.lang.String properties_biological;


	/**
	 *  A free-text description of the biological properties of the
	 *  material.
	 *  diverse biological activities including use as a
	 *  laxative and strong antibacterial activity against
	 *  S. aureus and weak activity against
	 *  cyclooxygenase-1 (COX-1)
	 *  antibiotic activity against Bacillus subtilis
	 *  (ATCC 6051) but no significant activity against
	 *  Candida albicans (ATCC 14053), Aspergillus flavus
	 *  (NRRL 6541) and Fusarium verticillioides (NRRL
	 *  25457)
	 *  weakly potent lipoxygenase nonredox inhibitor
	 *  no influenza A virus sialidase inhibitory and
	 *  plaque reduction activities
	 *  low toxicity against Drosophila melanogaster
	 */
	public java.lang.String getProperties_biological() 
	{
		return properties_biological;
	}
 
	public void setProperties_biological(java.lang.String properties_biological)
	{
		this.properties_biological = properties_biological;
	}

 	protected java.lang.String properties_physical;


	/**
	 *  A free-text description of the physical properties of the material.
	 *  air-sensitive
	 *  moisture-sensitive
	 *  hygroscopic
	 *  deliquescent
	 *  oxygen-sensitive
	 *  photo-sensitive
	 *  pyrophoric
	 *  semiconductor
	 *  ferromagnetic at low temperature
	 *  paramagnetic and thermochromic
	 */
	public java.lang.String getProperties_physical() 
	{
		return properties_physical;
	}
 
	public void setProperties_physical(java.lang.String properties_physical)
	{
		this.properties_physical = properties_physical;
	}

 	protected java.lang.Float temperature_decomposition;


	/**
	 *  The temperature in kelvins at which the solid decomposes.
	 *  350
	 */
	public java.lang.Float getTemperature_decomposition() 
	{
		return temperature_decomposition;
	}
 
	public void setTemperature_decomposition(java.lang.Float temperature_decomposition)
	{
		this.temperature_decomposition = temperature_decomposition;
	}

 	protected java.lang.Float temperature_decomposition_esd;


	/**
	 *  The estimated standard deviation of
	 *  attribute temperature_decomposition in category chemical.
	 */
	public java.lang.Float getTemperature_decomposition_esd() 
	{
		return temperature_decomposition_esd;
	}
 
	public void setTemperature_decomposition_esd(java.lang.Float temperature_decomposition_esd)
	{
		this.temperature_decomposition_esd = temperature_decomposition_esd;
	}

 	protected java.lang.Float temperature_decomposition_gt;


	/**
	 *  A temperature in kelvins above which the solid is known to
	 *  decompose.  attribute temperature_decomposition_gt in category chemical and
	 *  attribute temperature_decomposition_lt in category chemical allow
	 *  a range of temperatures to be given.
	 *  
	 *  attribute temperature_decomposition in category chemical should always be used in
	 *  preference to these two items whenever possible.
	 *  350
	 */
	public java.lang.Float getTemperature_decomposition_gt() 
	{
		return temperature_decomposition_gt;
	}
 
	public void setTemperature_decomposition_gt(java.lang.Float temperature_decomposition_gt)
	{
		this.temperature_decomposition_gt = temperature_decomposition_gt;
	}

 	protected java.lang.Float temperature_decomposition_lt;


	/**
	 *  A temperature in kelvins below which the solid is known to
	 *  decompose.  attribute temperature_decomposition_gt in category chemical and
	 *  attribute temperature_decomposition_lt in category chemical allow
	 *  a range of temperatures to be given.
	 *  
	 *  attribute temperature_decomposition in category chemical should always be used in
	 *  preference to these two items whenever possible.
	 *  350
	 */
	public java.lang.Float getTemperature_decomposition_lt() 
	{
		return temperature_decomposition_lt;
	}
 
	public void setTemperature_decomposition_lt(java.lang.Float temperature_decomposition_lt)
	{
		this.temperature_decomposition_lt = temperature_decomposition_lt;
	}

 	protected java.lang.Float temperature_sublimation;


	/**
	 *  The temperature in kelvins at which the solid sublimes.
	 *  350
	 */
	public java.lang.Float getTemperature_sublimation() 
	{
		return temperature_sublimation;
	}
 
	public void setTemperature_sublimation(java.lang.Float temperature_sublimation)
	{
		this.temperature_sublimation = temperature_sublimation;
	}

 	protected java.lang.Float temperature_sublimation_esd;


	/**
	 *  The estimated standard deviation of
	 *  attribute temperature_sublimation in category chemical.
	 */
	public java.lang.Float getTemperature_sublimation_esd() 
	{
		return temperature_sublimation_esd;
	}
 
	public void setTemperature_sublimation_esd(java.lang.Float temperature_sublimation_esd)
	{
		this.temperature_sublimation_esd = temperature_sublimation_esd;
	}

 	protected java.lang.Float temperature_sublimation_gt;


	/**
	 *  A temperature in kelvins above which the solid is known to
	 *  sublime.  attribute temperature_sublimation_gt in category chemical and
	 *  attribute temperature_sublimation_lt in category chemical allow a
	 *  range of temperatures to be given.
	 *  
	 *  attribute temperature_sublimation in category chemical should always be used in
	 *  preference to these two items whenever possible.
	 *  350
	 */
	public java.lang.Float getTemperature_sublimation_gt() 
	{
		return temperature_sublimation_gt;
	}
 
	public void setTemperature_sublimation_gt(java.lang.Float temperature_sublimation_gt)
	{
		this.temperature_sublimation_gt = temperature_sublimation_gt;
	}

 	protected java.lang.Float temperature_sublimation_lt;


	/**
	 *  A temperature in kelvins below which the solid is known to
	 *  sublime.  attribute temperature_sublimation_gt in category chemical and
	 *  attribute temperature_sublimation_lt in category chemical allow a
	 *  range of temperatures to be given.
	 *  
	 *  attribute temperature_sublimation in category chemical should always be used in
	 *  preference to these two items whenever possible.
	 *  350
	 */
	public java.lang.Float getTemperature_sublimation_lt() 
	{
		return temperature_sublimation_lt;
	}
 
	public void setTemperature_sublimation_lt(java.lang.Float temperature_sublimation_lt)
	{
		this.temperature_sublimation_lt = temperature_sublimation_lt;
	}

 }
