package org.pdb.beans;

/**
 *  Data items in the CITATION_EDITOR category record details
 *  about the editors associated with the books or book chapters
 *  cited in the CITATION list.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:citation_editorCategory>
 *  <PDBx:citation_editor citation_id="5" name="McKeever, B.M."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Navia, M.A."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Fitzgerald, P.M.D."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Springer, J.P."></PDBx:citation_editor>
 *  </PDBx:citation_editorCategory>
 * </pre>
 */
public class Citation_editor 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the CITATION
	 *  category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String name;


	/**
	 *  Names of an editor of the citation; relevant for books and
	 *  book chapters.
	 *  
	 *  The family name(s), followed by a comma and including any
	 *  dynastic components, precedes the first name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  This data item defines the order of the editor's name in the
	 *  list of editors of a citation.
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 }
