package org.pdb.beans;

/**
 *  Data items in the COMPUTING category record details about the
 *  computer programs used in the crystal structure analysis.
 *  
 *  Data items in this category would not, in general, be used in
 *  a macromolecular CIF.  The category SOFTWARE, which allows
 *  a more detailed description of computer programs and
 *  their attributes to be given, would be used instead.
 *  
 * <pre>
 *  Example 1 - Rodr\'iguez-Romera, Ruiz-P\'erez & Solans [Acta
 *  Cryst. (1996), C52, 1415-1417].
 *  <PDBx:computingCategory>
 *  <PDBx:computing>
 *  <PDBx:data_collection>CAD-4 (Enraf-Nonius, 1989)</PDBx:data_collection>
 *  <PDBx:cell_refinement>CAD-4 (Enraf-Nonius, 1989)</PDBx:cell_refinement>
 *  <PDBx:data_reduction>CFEO (Solans, 1978)</PDBx:data_reduction>
 *  <PDBx:structure_solution>SHELXS86 (Sheldrick, 1990)</PDBx:structure_solution>
 *  <PDBx:structure_refinement>SHELXL93 (Sheldrick, 1993)</PDBx:structure_refinement>
 *  <PDBx:molecular_graphics>ORTEPII (Johnson, 1976)</PDBx:molecular_graphics>
 *  <PDBx:publication_material>PARST (Nardelli, 1983)</PDBx:publication_material>
 *  </PDBx:computing>
 *  </PDBx:computingCategory>
 * </pre>
 */
public class Computing 
{
		protected java.lang.String cell_refinement;


	/**
	 *  Software used for cell refinement.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  CAD4 (Enraf-Nonius, 1989)
	 */
	public java.lang.String getCell_refinement() 
	{
		return cell_refinement;
	}
 
	public void setCell_refinement(java.lang.String cell_refinement)
	{
		this.cell_refinement = cell_refinement;
	}

 	protected java.lang.String data_collection;


	/**
	 *  Software used for data collection.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  CAD4 (Enraf-Nonius, 1989)
	 */
	public java.lang.String getData_collection() 
	{
		return data_collection;
	}
 
	public void setData_collection(java.lang.String data_collection)
	{
		this.data_collection = data_collection;
	}

 	protected java.lang.String data_reduction;


	/**
	 *  Software used for data reduction.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  DIFDAT, SORTRF, ADDREF (Hall & Stewart, 1990)
	 */
	public java.lang.String getData_reduction() 
	{
		return data_reduction;
	}
 
	public void setData_reduction(java.lang.String data_reduction)
	{
		this.data_reduction = data_reduction;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String molecular_graphics;


	/**
	 *  Software used for molecular graphics.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  FRODO (Jones, 1986), ORTEP (Johnson, 1965)
	 */
	public java.lang.String getMolecular_graphics() 
	{
		return molecular_graphics;
	}
 
	public void setMolecular_graphics(java.lang.String molecular_graphics)
	{
		this.molecular_graphics = molecular_graphics;
	}

 	protected java.lang.String pdbx_data_reduction_ds;


	/**
	 *  Program/package name for data reduction/data scaling
	 */
	public java.lang.String getPdbx_data_reduction_ds() 
	{
		return pdbx_data_reduction_ds;
	}
 
	public void setPdbx_data_reduction_ds(java.lang.String pdbx_data_reduction_ds)
	{
		this.pdbx_data_reduction_ds = pdbx_data_reduction_ds;
	}

 	protected java.lang.String pdbx_data_reduction_ii;


	/**
	 *  Program/package name for data reduction/intensity integration software
	 */
	public java.lang.String getPdbx_data_reduction_ii() 
	{
		return pdbx_data_reduction_ii;
	}
 
	public void setPdbx_data_reduction_ii(java.lang.String pdbx_data_reduction_ii)
	{
		this.pdbx_data_reduction_ii = pdbx_data_reduction_ii;
	}

 	protected java.lang.String pdbx_structure_refinement_method;


	/**
	 *  Program/package name for structure refinement method.
	 */
	public java.lang.String getPdbx_structure_refinement_method() 
	{
		return pdbx_structure_refinement_method;
	}
 
	public void setPdbx_structure_refinement_method(java.lang.String pdbx_structure_refinement_method)
	{
		this.pdbx_structure_refinement_method = pdbx_structure_refinement_method;
	}

 	protected java.lang.String publication_material;


	/**
	 *  Software used for generating material for publication.
	 *  
	 *  Give the program or package name and a brief reference.
	 */
	public java.lang.String getPublication_material() 
	{
		return publication_material;
	}
 
	public void setPublication_material(java.lang.String publication_material)
	{
		this.publication_material = publication_material;
	}

 	protected java.lang.String structure_refinement;


	/**
	 *  Software used for refinement of the structure.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  SHELX85 (Sheldrick, 1985)
	 *  X-PLOR (Brunger, 1992)
	 */
	public java.lang.String getStructure_refinement() 
	{
		return structure_refinement;
	}
 
	public void setStructure_refinement(java.lang.String structure_refinement)
	{
		this.structure_refinement = structure_refinement;
	}

 	protected java.lang.String structure_solution;


	/**
	 *  Software used for solution of the structure.
	 *  
	 *  Give the program or package name and a brief reference.
	 *  SHELX85 (Sheldrick, 1985)
	 */
	public java.lang.String getStructure_solution() 
	{
		return structure_solution;
	}
 
	public void setStructure_solution(java.lang.String structure_solution)
	{
		this.structure_solution = structure_solution;
	}

 }
