package org.pdb.beans;

/**
 *  Data items in the DATABASE_2 category record details about the
 *  database identifiers of the data block.
 *  
 *  These data items are assigned by database managers and should
 *  only appear in a data block if they originate from that source.
 *  
 *  The name of this category, DATABASE_2, arose because the
 *  category name DATABASE was already in use in the core CIF
 *  dictionary, but was used differently from the way it needed
 *  to be used in the mmCIF dictionary. Since CIF data names
 *  cannot be changed once they have been adopted, a new category
 *  had to be created.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:database_2Category>
 *  <PDBx:database_2 database_id="PDB" database_code="5HVP"></PDBx:database_2>
 *  </PDBx:database_2Category>
 * </pre>
 */
public class Database_2 
{
		protected java.lang.String database_code;


	/**
	 *  The code assigned by the database identified in
	 *  attribute database_id in category database_2.
	 *  1ABC
	 *  ABCDEF
	 */
	public java.lang.String getDatabase_code() 
	{
		return database_code;
	}
 
	public void setDatabase_code(java.lang.String database_code)
	{
		this.database_code = database_code;
	}

 	protected java.lang.String database_id;


	/**
	 *  An abbreviation that identifies the database.
	 */
	public java.lang.String getDatabase_id() 
	{
		return database_id;
	}
 
	public void setDatabase_id(java.lang.String database_id)
	{
		this.database_id = database_id;
	}

 }
