package org.pdb.beans;

/**
 *  Data items in the DATABASE_PDB_CAVEAT category record details
 *  about features of the data block flagged as 'caveats' by the
 *  Protein Data Bank (PDB).
 *  
 *  These data items are included only for consistency with PDB
 *  format files. They should appear in a data block only if that
 *  data block was created by reformatting a PDB format file.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:database_PDB_caveatCategory>
 *  <PDBx:database_PDB_caveat id="1">
 *  <PDBx:text> THE CRYSTAL TRANSFORMATION IS IN ERROR BUT IS</PDBx:text>
 *  </PDBx:database_PDB_caveat>
 *  <PDBx:database_PDB_caveat id="2">
 *  <PDBx:text> UNCORRECTABLE AT THIS TIME</PDBx:text>
 *  </PDBx:database_PDB_caveat>
 *  </PDBx:database_PDB_caveatCategory>
 * </pre>
 */
public class Database_PDB_caveat 
{
		protected java.lang.Integer id_;


	/**
	 *  A unique identifier for the PDB caveat record.
	 */
	public java.lang.Integer getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.Integer id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String text;


	/**
	 *  The full text of the PDB caveat record.
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
