package org.pdb.beans;

/**
 *  Data items in the DATABASE_PDB_REV category record details
 *  about the history of the data block as archived by the Protein
 *  Data Bank (PDB).
 *  
 *  These data items are assigned by the PDB database managers and
 *  should only appear in a data block if they originate from that
 *  source.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:database_PDB_revCategory>
 *  <PDBx:database_PDB_rev num="1">
 *  <PDBx:author_name>Fitzgerald, Paula M.D</PDBx:author_name>
 *  <PDBx:date>1991-10-15</PDBx:date>
 *  <PDBx:date_original>1990-04-30</PDBx:date_original>
 *  <PDBx:status>full release</PDBx:status>
 *  <PDBx:mod_type>0</PDBx:mod_type>
 *  </PDBx:database_PDB_rev>
 *  </PDBx:database_PDB_revCategory>
 * </pre>
 */
public class Database_PDB_rev 
{
		protected java.lang.String author_name;


	/**
	 *  The name of the person responsible for submitting this revision
	 *  to the PDB.
	 *  
	 *  The family name(s) followed by a comma precedes the first
	 *  name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getAuthor_name() 
	{
		return author_name;
	}
 
	public void setAuthor_name(java.lang.String author_name)
	{
		this.author_name = author_name;
	}

 	protected java.util.Date date;


	/**
	 *  Date the PDB revision took place. Taken from the REVDAT record.
	 */
	public java.util.Date getDate() 
	{
		return date;
	}
 
	public void setDate(java.util.Date date)
	{
		this.date = date;
	}

 	protected java.util.Date date_original;


	/**
	 *  Date the entry first entered the PDB database in the form
	 *  yyyy-mm-dd. Taken from the PDB HEADER record.
	 *  1980-08-21
	 */
	public java.util.Date getDate_original() 
	{
		return date_original;
	}
 
	public void setDate_original(java.util.Date date_original)
	{
		this.date_original = date_original;
	}

 	protected java.lang.Integer mod_type;


	/**
	 *  Taken from the REVDAT record. Refer to the Protein Data Bank
	 *  format description at
	 *  http://www.rcsb.org/pdb/docs/format/pdbguide2.2/guide2.2_frame.html
	 *  for details.
	 */
	public java.lang.Integer getMod_type() 
	{
		return mod_type;
	}
 
	public void setMod_type(java.lang.Integer mod_type)
	{
		this.mod_type = mod_type;
	}

 	protected java.lang.Integer num;


	/**
	 *  The value of  attribute num in category database_PDB_rev must uniquely and
	 *  sequentially identify a record in the DATABASE_PDB_REV list.
	 *  
	 *  Note that this item must be a number and that modification
	 *  numbers are assigned in increasing numerical order.
	 */
	public java.lang.Integer getNum() 
	{
		return num;
	}
 
	public void setNum(java.lang.Integer num)
	{
		this.num = num;
	}

 	protected java.lang.String replaced_by;


	/**
	 *  The PDB code for a subsequent PDB entry that replaced the
	 *  PDB file corresponding to this data block.
	 */
	public java.lang.String getReplaced_by() 
	{
		return replaced_by;
	}
 
	public void setReplaced_by(java.lang.String replaced_by)
	{
		this.replaced_by = replaced_by;
	}

 	protected java.lang.String replaces;


	/**
	 *  The PDB code for a previous PDB entry that was replaced by
	 *  the PDB file corresponding to this data block.
	 */
	public java.lang.String getReplaces() 
	{
		return replaces;
	}
 
	public void setReplaces(java.lang.String replaces)
	{
		this.replaces = replaces;
	}

 	protected java.lang.String status;


	/**
	 *  The status of this revision.
	 */
	public java.lang.String getStatus() 
	{
		return status;
	}
 
	public void setStatus(java.lang.String status)
	{
		this.status = status;
	}

 }
