package org.pdb.beans;

/**
 *  The DATABASE_PDB_TVECT category provides placeholders for
 *  the TVECT matrices and vectors used by the Protein Data
 *  Bank (PDB).
 *  
 *  These data items are included only for consistency with older
 *  PDB format files. They should appear in a data block only if
 *  the data block was created by reformatting a PDB format file.
 */
public class Database_PDB_tvect 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of this TVECT.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category database_PDB_tvect must uniquely identify a
	 *  record in the DATABASE_PDB_TVECT list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float vector1;


	/**
	 *  The [1] element of the PDB TVECT vector.
	 */
	public java.lang.Float getVector1() 
	{
		return vector1;
	}
 
	public void setVector1(java.lang.Float vector1)
	{
		this.vector1 = vector1;
	}

 	protected java.lang.Float vector2;


	/**
	 *  The [2] element of the PDB TVECT vector.
	 */
	public java.lang.Float getVector2() 
	{
		return vector2;
	}
 
	public void setVector2(java.lang.Float vector2)
	{
		this.vector2 = vector2;
	}

 	protected java.lang.Float vector3;


	/**
	 *  The [3] element of the PDB TVECT vector.
	 */
	public java.lang.Float getVector3() 
	{
		return vector3;
	}
 
	public void setVector3(java.lang.Float vector3)
	{
		this.vector3 = vector3;
	}

 }
