package org.pdb.beans;

/**
 *  Data items in the DIFFRN_ORIENT_REFLN category record details
 *  about the reflections that define the orientation matrix used in
 *  the measurement of the diffraction intensities.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_orient_reflnCategory>
 *  <PDBx:diffrn_orient_refln diffrn_id="myset1" index_h="2" index_k="0" index_l="2">
 *  <PDBx:angle_chi>-28.45</PDBx:angle_chi>
 *  <PDBx:angle_kappa>-11.32</PDBx:angle_kappa>
 *  <PDBx:angle_omega>5.33</PDBx:angle_omega>
 *  <PDBx:angle_phi>101.78</PDBx:angle_phi>
 *  <PDBx:angle_psi>0.00</PDBx:angle_psi>
 *  <PDBx:angle_theta>10.66</PDBx:angle_theta>
 *  </PDBx:diffrn_orient_refln>
 *  </PDBx:diffrn_orient_reflnCategory>
 * </pre>
 */
public class Diffrn_orient_refln 
{
		protected java.lang.Float angle_chi;


	/**
	 *  Diffractometer angle chi of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices
	 *  in the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_chi() 
	{
		return angle_chi;
	}
 
	public void setAngle_chi(java.lang.Float angle_chi)
	{
		this.angle_chi = angle_chi;
	}

 	protected java.lang.Float angle_kappa;


	/**
	 *  Diffractometer angle kappa of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices
	 *  in the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_kappa() 
	{
		return angle_kappa;
	}
 
	public void setAngle_kappa(java.lang.Float angle_kappa)
	{
		this.angle_kappa = angle_kappa;
	}

 	protected java.lang.Float angle_omega;


	/**
	 *  Diffractometer angle omega of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices in
	 *  the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_omega() 
	{
		return angle_omega;
	}
 
	public void setAngle_omega(java.lang.Float angle_omega)
	{
		this.angle_omega = angle_omega;
	}

 	protected java.lang.Float angle_phi;


	/**
	 *  Diffractometer angle phi of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices
	 *  in the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_phi() 
	{
		return angle_phi;
	}
 
	public void setAngle_phi(java.lang.Float angle_phi)
	{
		this.angle_phi = angle_phi;
	}

 	protected java.lang.Float angle_psi;


	/**
	 *  Diffractometer angle psi of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices
	 *  in the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_psi() 
	{
		return angle_psi;
	}
 
	public void setAngle_psi(java.lang.Float angle_psi)
	{
		this.angle_psi = angle_psi;
	}

 	protected java.lang.Float angle_theta;


	/**
	 *  Diffractometer angle theta of a reflection used to
	 *  define the orientation matrix in degrees. See
	 *  attribute UB[][] in category diffrn_orient_matrix and the Miller indices
	 *  in the DIFFRN_ORIENT_REFLN category.
	 */
	public java.lang.Float getAngle_theta() 
	{
		return angle_theta;
	}
 
	public void setAngle_theta(java.lang.Float angle_theta)
	{
		this.angle_theta = angle_theta;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of a reflection used to define the orientation
	 *  matrix.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of a reflection used to define the orientation
	 *  matrix.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of a reflection used to define the orientation
	 *  matrix.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 }
