package org.pdb.beans;

/**
 *  Data items in the DIFFRN_RADIATION category describe
 *  the radiation used in measuring the diffraction intensities,
 *  its collimation and monochromatization before the sample.
 *  
 *  Post-sample treatment of the beam is described by data
 *  items in the DIFFRN_DETECTOR category.
 *  
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_radiationCategory>
 *  <PDBx:diffrn_radiation diffrn_id="set1">
 *  <PDBx:collimation>0.3 mm double pinhole</PDBx:collimation>
 *  <PDBx:monochromator>graphite</PDBx:monochromator>
 *  <PDBx:type>Cu K\a</PDBx:type>
 *  <PDBx:wavelength_id>1</PDBx:wavelength_id>
 *  </PDBx:diffrn_radiation>
 *  </PDBx:diffrn_radiationCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_radiationCategory>
 *  <PDBx:diffrn_radiation>
 *  <PDBx:wavelength_id>1</PDBx:wavelength_id>
 *  <PDBx:type>Cu K\a</PDBx:type>
 *  <PDBx:monochromator>graphite</PDBx:monochromator>
 *  </PDBx:diffrn_radiation>
 *  </PDBx:diffrn_radiationCategory>
 * </pre>
 */
public class Diffrn_radiation 
{
		protected java.lang.String collimation;


	/**
	 *  The collimation or focusing applied to the radiation.
	 *  0.3 mm double-pinhole
	 *  0.5 mm
	 *  focusing mirrors
	 */
	public java.lang.String getCollimation() 
	{
		return collimation;
	}
 
	public void setCollimation(java.lang.String collimation)
	{
		this.collimation = collimation;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Float filter_edge;


	/**
	 *  Absorption edge in angstroms of the radiation filter used.
	 */
	public java.lang.Float getFilter_edge() 
	{
		return filter_edge;
	}
 
	public void setFilter_edge(java.lang.Float filter_edge)
	{
		this.filter_edge = filter_edge;
	}

 	protected java.lang.Float inhomogeneity;


	/**
	 *  Half-width in millimetres of the incident beam in the
	 *  direction perpendicular to the diffraction plane.
	 */
	public java.lang.Float getInhomogeneity() 
	{
		return inhomogeneity;
	}
 
	public void setInhomogeneity(java.lang.Float inhomogeneity)
	{
		this.inhomogeneity = inhomogeneity;
	}

 	protected java.lang.String monochromator;


	/**
	 *  The method used to obtain monochromatic radiation. If a mono-
	 *  chromator crystal is used, the material and the indices of the
	 *  Bragg reflection are specified.
	 *  Zr filter
	 *  Ge 220
	 *  none
	 *  equatorial mounted graphite
	 */
	public java.lang.String getMonochromator() 
	{
		return monochromator;
	}
 
	public void setMonochromator(java.lang.String monochromator)
	{
		this.monochromator = monochromator;
	}

 	protected java.lang.String pdbx_analyzer;


	/**
	 *  Indicates the method used to obtain monochromatic radiation.
	 *  attribute monochromator in category diffrn_radiation describes the primary beam
	 *  monochromator (pre-specimen monochromation).
	 *  attribute pdbx_analyzer in category diffrn_radiation specifies the
	 *  post-diffraction analyser (post-specimen) monochromation.
	 *  Note that monochromators may have either 'parallel' or
	 *  'antiparallel' orientation. It is assumed that the
	 *  geometry is parallel unless specified otherwise.
	 *  In a parallel geometry, the position of the monochromator
	 *  allows the incident beam and the final post-specimen
	 *  and post-monochromator beam to be as close to parallel
	 *  as possible. In a parallel geometry, the diffracting
	 *  planes in the specimen and monochromator will be parallel
	 *  when 2*theta(monochromator) is equal to 2*theta (specimen).
	 *  For further discussion see R. Jenkins and R. Snyder,
	 *  Introduction to X-ray Powder Diffraction, Wiley (1996),
	 *  pp. 164-5.
	 *  GE(111)
	 *  Zr filter
	 *  Ge 220
	 *  none
	 *  equatorial mounted graphite (0001)
	 *  Si (111), antiparallel
	 */
	public java.lang.String getPdbx_analyzer() 
	{
		return pdbx_analyzer;
	}
 
	public void setPdbx_analyzer(java.lang.String pdbx_analyzer)
	{
		this.pdbx_analyzer = pdbx_analyzer;
	}

 	protected java.lang.String pdbx_diffrn_protocol;


	/**
	 *  SINGLE WAVELENGTH, LAUE, or MAD.
	 *  SINGLE WAVELENGTH
	 *  MONOCHROMATIC
	 *  LAUE
	 *  MAD
	 *  OTHER
	 */
	public java.lang.String getPdbx_diffrn_protocol() 
	{
		return pdbx_diffrn_protocol;
	}
 
	public void setPdbx_diffrn_protocol(java.lang.String pdbx_diffrn_protocol)
	{
		this.pdbx_diffrn_protocol = pdbx_diffrn_protocol;
	}

 	protected java.lang.String pdbx_monochromatic_or_laue_m_l;


	/**
	 *  Monochromatic or Laue.
	 *  M
	 *  L
	 */
	public java.lang.String getPdbx_monochromatic_or_laue_m_l() 
	{
		return pdbx_monochromatic_or_laue_m_l;
	}
 
	public void setPdbx_monochromatic_or_laue_m_l(java.lang.String pdbx_monochromatic_or_laue_m_l)
	{
		this.pdbx_monochromatic_or_laue_m_l = pdbx_monochromatic_or_laue_m_l;
	}

 	protected java.lang.String pdbx_wavelength;


	/**
	 *  Wavelength of radiation.
	 */
	public java.lang.String getPdbx_wavelength() 
	{
		return pdbx_wavelength;
	}
 
	public void setPdbx_wavelength(java.lang.String pdbx_wavelength)
	{
		this.pdbx_wavelength = pdbx_wavelength;
	}

 	protected java.lang.String pdbx_wavelength_list;


	/**
	 *  Comma separated list of wavelengths or wavelength range.
	 */
	public java.lang.String getPdbx_wavelength_list() 
	{
		return pdbx_wavelength_list;
	}
 
	public void setPdbx_wavelength_list(java.lang.String pdbx_wavelength_list)
	{
		this.pdbx_wavelength_list = pdbx_wavelength_list;
	}

 	protected java.lang.Float polarisn_norm;


	/**
	 *  The angle in degrees, as viewed from the specimen, between the
	 *  perpendicular component of the polarization and the diffraction
	 *  plane. See  attribute polarisn_ratio in category diffrn_radiation.
	 */
	public java.lang.Float getPolarisn_norm() 
	{
		return polarisn_norm;
	}
 
	public void setPolarisn_norm(java.lang.Float polarisn_norm)
	{
		this.polarisn_norm = polarisn_norm;
	}

 	protected java.lang.Float polarisn_ratio;


	/**
	 *  Polarization ratio of the diffraction beam incident on the
	 *  crystal. This is the ratio of the perpendicularly polarized
	 *  to the parallel-polarized component of the radiation. The
	 *  perpendicular component forms an angle of
	 *  attribute polarisn_norm in category diffrn_radiation to the normal to the
	 *  diffraction plane of the sample (i.e. the plane containing
	 *  the incident and reflected beams).
	 */
	public java.lang.Float getPolarisn_ratio() 
	{
		return polarisn_ratio;
	}
 
	public void setPolarisn_ratio(java.lang.Float polarisn_ratio)
	{
		this.polarisn_ratio = polarisn_ratio;
	}

 	protected java.lang.String probe;


	/**
	 *  The nature of the radiation used (i.e. the name of the
	 *  subatomic particle or the region of the electromagnetic
	 *  spectrum). It is strongly recommended that this information
	 *  is given, so that the probe radiation can be simply determined.
	 */
	public java.lang.String getProbe() 
	{
		return probe;
	}
 
	public void setProbe(java.lang.String probe)
	{
		this.probe = probe;
	}

 	protected java.lang.String type;


	/**
	 *  The nature of the radiation. This is typically a description
	 *  of the X-ray wavelength in Siegbahn notation.
	 *  CuK\a
	 *  Cu K\a~1~
	 *  Cu K-L~2,3~
	 *  white-beam
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.String wavelength_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category diffrn_radiation_wavelength in the DIFFRN_RADIATION_WAVELENGTH category.
	 */
	public java.lang.String getWavelength_id() 
	{
		return wavelength_id;
	}
 
	public void setWavelength_id(java.lang.String wavelength_id)
	{
		this.wavelength_id = wavelength_id;
	}

 	protected java.lang.String xray_symbol;


	/**
	 *  The IUPAC symbol for the X-ray wavelength for the probe
	 *  radiation.
	 */
	public java.lang.String getXray_symbol() 
	{
		return xray_symbol;
	}
 
	public void setXray_symbol(java.lang.String xray_symbol)
	{
		this.xray_symbol = xray_symbol;
	}

 }
