package org.pdb.beans;

/**
 *  Data items in the DIFFRN_RADIATION_WAVELENGTH category
 *  describe the wavelength of the radiation used to measure the
 *  diffraction intensities. Items may be looped to identify
 *  and assign weights to distinct components of a
 *  polychromatic beam.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_radiation_wavelengthCategory>
 *  <PDBx:diffrn_radiation_wavelength id="1">
 *  <PDBx:wavelength>1.54</PDBx:wavelength>
 *  <PDBx:wt>1.0</PDBx:wt>
 *  </PDBx:diffrn_radiation_wavelength>
 *  </PDBx:diffrn_radiation_wavelengthCategory>
 * </pre>
 */
public class Diffrn_radiation_wavelength 
{
		protected java.lang.String id_;


	/**
	 *  The code identifying each value of
	 *  attribute wavelength.
	 *  in category diffrn_radiation_wavelength Items in the DIFFRN_RADIATION_WAVELENGTH category are looped
	 *  when multiple wavelengths are used.
	 *  
	 *  This code is used to link with the DIFFRN_REFLN category.
	 *  The  attribute wavelength_id in category diffrn_refln codes must match one of
	 *  the codes defined in this category.
	 *  x1
	 *  x2
	 *  neut
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float wavelength;


	/**
	 *  The radiation wavelength in angstroms.
	 */
	public java.lang.Float getWavelength() 
	{
		return wavelength;
	}
 
	public void setWavelength(java.lang.Float wavelength)
	{
		this.wavelength = wavelength;
	}

 	protected java.lang.Float wt;


	/**
	 *  The relative weight of a wavelength identified by the code
	 *  attribute id in category diffrn_radiation_wavelength in the list of wavelengths.
	 */
	public java.lang.Float getWt() 
	{
		return wt;
	}
 
	public void setWt(java.lang.Float wt)
	{
		this.wt = wt;
	}

 }
