package org.pdb.beans;

/**
 *  Data items in the DIFFRN_REFLNS category record details about
 *  the set of intensities measured in the diffraction experiment.
 *  
 *  The DIFFRN_REFLN data items refer to individual intensity
 *  measurements and must be included in looped lists.
 *  
 *  The DIFFRN_REFLNS data items specify the parameters that apply
 *  to all intensity measurements in a diffraction data set.
 */
public class Diffrn_reflns 
{
		protected java.lang.Float av_R_equivalents;


	/**
	 *  The residual [sum|avdel(I)| / sum|av(I)|] for symmetry-equivalent
	 *  reflections used to calculate the average intensity av(I). The
	 *  avdel(I) term is the average absolute difference between av(I)
	 *  and the individual symmetry-equivalent intensities.
	 */
	public java.lang.Float getAv_R_equivalents() 
	{
		return av_R_equivalents;
	}
 
	public void setAv_R_equivalents(java.lang.Float av_R_equivalents)
	{
		this.av_R_equivalents = av_R_equivalents;
	}

 	protected java.lang.Float av_sigmaI_over_netI;


	/**
	 *  Measure [sum|sigma(I)|/sum|net(I)|] for all measured reflections.
	 */
	public java.lang.Float getAv_sigmaI_over_netI() 
	{
		return av_sigmaI_over_netI;
	}
 
	public void setAv_sigmaI_over_netI(java.lang.Float av_sigmaI_over_netI)
	{
		this.av_sigmaI_over_netI = av_sigmaI_over_netI;
	}

 	protected java.lang.Float av_unetI_over_netI;


	/**
	 *  Measure [sum u(net I)|/sum|net I|] for all measured reflections.
	 */
	public java.lang.Float getAv_unetI_over_netI() 
	{
		return av_unetI_over_netI;
	}
 
	public void setAv_unetI_over_netI(java.lang.Float av_unetI_over_netI)
	{
		this.av_unetI_over_netI = av_unetI_over_netI;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Integer limit_h_max;


	/**
	 *  The maximum value of the Miller index h for the
	 *  reflection data specified by  attribute index_h in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_h_max() 
	{
		return limit_h_max;
	}
 
	public void setLimit_h_max(java.lang.Integer limit_h_max)
	{
		this.limit_h_max = limit_h_max;
	}

 	protected java.lang.Integer limit_h_min;


	/**
	 *  The minimum value of the Miller index h for the
	 *  reflection data specified by  attribute index_h in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_h_min() 
	{
		return limit_h_min;
	}
 
	public void setLimit_h_min(java.lang.Integer limit_h_min)
	{
		this.limit_h_min = limit_h_min;
	}

 	protected java.lang.Integer limit_k_max;


	/**
	 *  The maximum value of the Miller index k for the
	 *  reflection data specified by  attribute index_k in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_k_max() 
	{
		return limit_k_max;
	}
 
	public void setLimit_k_max(java.lang.Integer limit_k_max)
	{
		this.limit_k_max = limit_k_max;
	}

 	protected java.lang.Integer limit_k_min;


	/**
	 *  The minimum value of the Miller index k for the
	 *  reflection data specified by  attribute index_k in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_k_min() 
	{
		return limit_k_min;
	}
 
	public void setLimit_k_min(java.lang.Integer limit_k_min)
	{
		this.limit_k_min = limit_k_min;
	}

 	protected java.lang.Integer limit_l_max;


	/**
	 *  The maximum value of the Miller index l for the
	 *  reflection data specified by  attribute index_l in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_l_max() 
	{
		return limit_l_max;
	}
 
	public void setLimit_l_max(java.lang.Integer limit_l_max)
	{
		this.limit_l_max = limit_l_max;
	}

 	protected java.lang.Integer limit_l_min;


	/**
	 *  The minimum value of the Miller index l for the
	 *  reflection data specified by  attribute index_l in category diffrn_refln.
	 */
	public java.lang.Integer getLimit_l_min() 
	{
		return limit_l_min;
	}
 
	public void setLimit_l_min(java.lang.Integer limit_l_min)
	{
		this.limit_l_min = limit_l_min;
	}

 	protected java.lang.Integer number;


	/**
	 *  The total number of measured intensities, excluding reflections
	 *  that are classified as systematically absent.
	 */
	public java.lang.Integer getNumber() 
	{
		return number;
	}
 
	public void setNumber(java.lang.Integer number)
	{
		this.number = number;
	}

 	protected java.lang.String reduction_process;


	/**
	 *  A description of the process used to reduce the intensity data
	 *  into structure-factor magnitudes.
	 *  data averaged using Fisher test
	 */
	public java.lang.String getReduction_process() 
	{
		return reduction_process;
	}
 
	public void setReduction_process(java.lang.String reduction_process)
	{
		this.reduction_process = reduction_process;
	}

 	protected java.lang.Float theta_max;


	/**
	 *  Maximum theta angle in degrees for the measured diffraction
	 *  intensities.
	 */
	public java.lang.Float getTheta_max() 
	{
		return theta_max;
	}
 
	public void setTheta_max(java.lang.Float theta_max)
	{
		this.theta_max = theta_max;
	}

 	protected java.lang.Float theta_min;


	/**
	 *  Minimum theta angle in degrees for the measured diffraction
	 *  intensities.
	 */
	public java.lang.Float getTheta_min() 
	{
		return theta_min;
	}
 
	public void setTheta_min(java.lang.Float theta_min)
	{
		this.theta_min = theta_min;
	}

 	protected java.lang.Float transf_matrix11;


	/**
	 *  The [1][1] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix11() 
	{
		return transf_matrix11;
	}
 
	public void setTransf_matrix11(java.lang.Float transf_matrix11)
	{
		this.transf_matrix11 = transf_matrix11;
	}

 	protected java.lang.Float transf_matrix12;


	/**
	 *  The [1][2] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix12() 
	{
		return transf_matrix12;
	}
 
	public void setTransf_matrix12(java.lang.Float transf_matrix12)
	{
		this.transf_matrix12 = transf_matrix12;
	}

 	protected java.lang.Float transf_matrix13;


	/**
	 *  The [1][3] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix13() 
	{
		return transf_matrix13;
	}
 
	public void setTransf_matrix13(java.lang.Float transf_matrix13)
	{
		this.transf_matrix13 = transf_matrix13;
	}

 	protected java.lang.Float transf_matrix21;


	/**
	 *  The [2][1] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix21() 
	{
		return transf_matrix21;
	}
 
	public void setTransf_matrix21(java.lang.Float transf_matrix21)
	{
		this.transf_matrix21 = transf_matrix21;
	}

 	protected java.lang.Float transf_matrix22;


	/**
	 *  The [2][2] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix22() 
	{
		return transf_matrix22;
	}
 
	public void setTransf_matrix22(java.lang.Float transf_matrix22)
	{
		this.transf_matrix22 = transf_matrix22;
	}

 	protected java.lang.Float transf_matrix23;


	/**
	 *  The [2][3] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix23() 
	{
		return transf_matrix23;
	}
 
	public void setTransf_matrix23(java.lang.Float transf_matrix23)
	{
		this.transf_matrix23 = transf_matrix23;
	}

 	protected java.lang.Float transf_matrix31;


	/**
	 *  The [3][1] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix31() 
	{
		return transf_matrix31;
	}
 
	public void setTransf_matrix31(java.lang.Float transf_matrix31)
	{
		this.transf_matrix31 = transf_matrix31;
	}

 	protected java.lang.Float transf_matrix32;


	/**
	 *  The [3][2] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix32() 
	{
		return transf_matrix32;
	}
 
	public void setTransf_matrix32(java.lang.Float transf_matrix32)
	{
		this.transf_matrix32 = transf_matrix32;
	}

 	protected java.lang.Float transf_matrix33;


	/**
	 *  The [3][3] element of the 3x3 matrix used to transform Miller
	 *  indices in the DIFFRN_REFLN category into the Miller indices in
	 *  the REFLN category.
	 */
	public java.lang.Float getTransf_matrix33() 
	{
		return transf_matrix33;
	}
 
	public void setTransf_matrix33(java.lang.Float transf_matrix33)
	{
		this.transf_matrix33 = transf_matrix33;
	}

 }
