package org.pdb.beans;

/**
 *  Data items in the DIFFRN_REFLNS_CLASS category record details
 *  about the classes of reflections measured in the diffraction
 *  experiment.
 *  
 * <pre>
 *  Example 1 - example corresponding to the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~. Each reflection class is
 *  defined by the number m=sum|m~i~|, where the m~i~ are the
 *  integer coefficients that, in addition to h,k,l, index the
 *  corresponding diffraction vector in the basis defined for
 *  the reciprocal lattice.
 *  <PDBx:diffrn_reflns_classCategory>
 *  <PDBx:diffrn_reflns_class code="Main">
 *  <PDBx:number>1580</PDBx:number>
 *  <PDBx:d_res_high>0.551</PDBx:d_res_high>
 *  <PDBx:d_res_low>6.136</PDBx:d_res_low>
 *  <PDBx:av_R_eq>0.015</PDBx:av_R_eq>
 *  <PDBx:description>m=0; main reflections</PDBx:description>
 *  </PDBx:diffrn_reflns_class>
 *  <PDBx:diffrn_reflns_class code="Sat1">
 *  <PDBx:number>1045</PDBx:number>
 *  <PDBx:d_res_high>0.551</PDBx:d_res_high>
 *  <PDBx:d_res_low>6.136</PDBx:d_res_low>
 *  <PDBx:av_R_eq>0.010</PDBx:av_R_eq>
 *  <PDBx:description>m=1; first-order satellites</PDBx:description>
 *  </PDBx:diffrn_reflns_class>
 *  </PDBx:diffrn_reflns_classCategory>
 * </pre>
 */
public class Diffrn_reflns_class 
{
		protected java.lang.Float av_R_eq;


	/**
	 *  For each reflection class, the residual
	 *  [sum av|del(I)|/sum|av(I)|] for symmetry-equivalent reflections
	 *  used to calculate the average intensity av(I). The av|del(I)|
	 *  term is the average absolute difference between av(I) and the
	 *  individual intensities.
	 */
	public java.lang.Float getAv_R_eq() 
	{
		return av_R_eq;
	}
 
	public void setAv_R_eq(java.lang.Float av_R_eq)
	{
		this.av_R_eq = av_R_eq;
	}

 	protected java.lang.Float av_sgI_over_I;


	/**
	 *  Measure [sum|sigma(net I)|/sum|net I|] for all measured intensities
	 *  in a reflection class.
	 */
	public java.lang.Float getAv_sgI_over_I() 
	{
		return av_sgI_over_I;
	}
 
	public void setAv_sgI_over_I(java.lang.Float av_sgI_over_I)
	{
		this.av_sgI_over_I = av_sgI_over_I;
	}

 	protected java.lang.Float av_uI_over_I;


	/**
	 *  Measure [sum|u(net I)|/sum|net I|] for all measured intensities
	 *  in a reflection class.
	 */
	public java.lang.Float getAv_uI_over_I() 
	{
		return av_uI_over_I;
	}
 
	public void setAv_uI_over_I(java.lang.Float av_uI_over_I)
	{
		this.av_uI_over_I = av_uI_over_I;
	}

 	protected java.lang.String code;


	/**
	 *  The code identifying a certain reflection class.
	 *  1
	 *  m1
	 *  s2
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.Float d_res_high;


	/**
	 *  The smallest value in angstroms for the interplanar
	 *  spacings for the reflections in each measured reflection class.
	 *  This is called the highest resolution for this reflection class.
	 */
	public java.lang.Float getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Float d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.Float d_res_low;


	/**
	 *  The largest value in angstroms of the interplanar
	 *  spacings for the reflections for each measured reflection class.
	 *  This is called the lowest resolution for this reflection class.
	 */
	public java.lang.Float getD_res_low() 
	{
		return d_res_low;
	}
 
	public void setD_res_low(java.lang.Float d_res_low)
	{
		this.d_res_low = d_res_low;
	}

 	protected java.lang.String description;


	/**
	 *  Description of each reflection class.
	 *  m=1 first order satellites
	 *  H0L0 common projection reflections
	 */
	public java.lang.String getDescription() 
	{
		return description;
	}
 
	public void setDescription(java.lang.String description)
	{
		this.description = description;
	}

 	protected java.lang.Integer number;


	/**
	 *  The total number of measured intensities for each reflection
	 *  class, excluding the systematic absences arising from
	 *  centring translations.
	 */
	public java.lang.Integer getNumber() 
	{
		return number;
	}
 
	public void setNumber(java.lang.Integer number)
	{
		this.number = number;
	}

 }
