package org.pdb.beans;

/**
 *  Data items in the DIFFRN_SCALE_GROUP category record details
 *  of the scaling factors applied to place all intensities in the
 *  reflection lists on a common scale.
 *  Scaling groups might, for example, correspond to each film in a
 *  multi-film data set or each crystal in a multi-crystal data set.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_scale_groupCategory>
 *  <PDBx:diffrn_scale_group code="A24">
 *  <PDBx:I_net>1.021</PDBx:I_net>
 *  </PDBx:diffrn_scale_group>
 *  </PDBx:diffrn_scale_groupCategory>
 * </pre>
 */
public class Diffrn_scale_group 
{
		protected java.lang.Float I_net;


	/**
	 *  The scale for a specific measurement group which is to be
	 *  multiplied with the net intensity to place all intensities
	 *  in the DIFFRN_REFLN or REFLN list on a common scale.
	 */
	public java.lang.Float getI_net() 
	{
		return I_net;
	}
 
	public void setI_net(java.lang.Float I_net)
	{
		this.I_net = I_net;
	}

 	protected java.lang.String code;


	/**
	 *  The value of  attribute code in category diffrn_scale_group must uniquely identify a
	 *  record in the DIFFRN_SCALE_GROUP list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  1
	 *  2
	 *  c1
	 *  c2
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 }
