package org.pdb.beans;

/**
 *  Data items in the DIFFRN_SOURCE category record details of
 *  the source of radiation used in the diffraction experiment.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_sourceCategory>
 *  <PDBx:diffrn_source diffrn_id="s1">
 *  <PDBx:source>rotating anode</PDBx:source>
 *  <PDBx:type>Rigaku RU-200</PDBx:type>
 *  <PDBx:power>50.</PDBx:power>
 *  <PDBx:current>180.</PDBx:current>
 *  <PDBx:size>8mm x 0.4 mm broad-focus</PDBx:size>
 *  </PDBx:diffrn_source>
 *  </PDBx:diffrn_sourceCategory>
 * </pre>
 */
public class Diffrn_source 
{
		protected java.lang.Float current;


	/**
	 *  The current in milliamperes at which the radiation source
	 *  was operated.
	 */
	public java.lang.Float getCurrent() 
	{
		return current;
	}
 
	public void setCurrent(java.lang.Float current)
	{
		this.current = current;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the radiation source used.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.String pdbx_synchrotron_beamline;


	/**
	 *  Synchrotron beamline.
	 */
	public java.lang.String getPdbx_synchrotron_beamline() 
	{
		return pdbx_synchrotron_beamline;
	}
 
	public void setPdbx_synchrotron_beamline(java.lang.String pdbx_synchrotron_beamline)
	{
		this.pdbx_synchrotron_beamline = pdbx_synchrotron_beamline;
	}

 	protected java.lang.String pdbx_synchrotron_site;


	/**
	 *  Synchrotron site.
	 */
	public java.lang.String getPdbx_synchrotron_site() 
	{
		return pdbx_synchrotron_site;
	}
 
	public void setPdbx_synchrotron_site(java.lang.String pdbx_synchrotron_site)
	{
		this.pdbx_synchrotron_site = pdbx_synchrotron_site;
	}

 	protected java.lang.String pdbx_wavelength;


	/**
	 *  Wavelength of radiation.
	 */
	public java.lang.String getPdbx_wavelength() 
	{
		return pdbx_wavelength;
	}
 
	public void setPdbx_wavelength(java.lang.String pdbx_wavelength)
	{
		this.pdbx_wavelength = pdbx_wavelength;
	}

 	protected java.lang.String pdbx_wavelength_list;


	/**
	 *  Comma separated list of wavelengths or wavelength range.
	 */
	public java.lang.String getPdbx_wavelength_list() 
	{
		return pdbx_wavelength_list;
	}
 
	public void setPdbx_wavelength_list(java.lang.String pdbx_wavelength_list)
	{
		this.pdbx_wavelength_list = pdbx_wavelength_list;
	}

 	protected java.lang.Float power;


	/**
	 *  The power in kilowatts at which the radiation source
	 *  was operated.
	 */
	public java.lang.Float getPower() 
	{
		return power;
	}
 
	public void setPower(java.lang.Float power)
	{
		this.power = power;
	}

 	protected java.lang.String size;


	/**
	 *  The dimensions of the source as viewed from the sample.
	 *  8mm x 0.4 mm fine-focus
	 *  broad focus
	 */
	public java.lang.String getSize() 
	{
		return size;
	}
 
	public void setSize(java.lang.String size)
	{
		this.size = size;
	}

 	protected java.lang.String source;


	/**
	 *  The general class of the radiation source.
	 *  sealed X-ray tube
	 *  nuclear reactor
	 *  spallation source
	 *  electron microscope
	 *  rotating-anode X-ray tube
	 *  synchrotron
	 */
	public java.lang.String getSource() 
	{
		return source;
	}
 
	public void setSource(java.lang.String source)
	{
		this.source = source;
	}

 	protected java.lang.Float take_off_angle;


	/**
	 *  The complement of the angle in degrees between the normal
	 *  to the surface of the X-ray tube target and the primary
	 *  X-ray beam for beams generated by traditional X-ray tubes.
	 *  1.5
	 */
	public java.lang.Float getTake_off_angle() 
	{
		return take_off_angle;
	}
 
	public void setTake_off_angle(java.lang.Float take_off_angle)
	{
		this.take_off_angle = take_off_angle;
	}

 	protected java.lang.String target;


	/**
	 *  The chemical element symbol for the X-ray target
	 *  (usually the anode) used to generate X-rays.
	 *  This can also be used for spallation sources.
	 */
	public java.lang.String getTarget() 
	{
		return target;
	}
 
	public void setTarget(java.lang.String target)
	{
		this.target = target;
	}

 	protected java.lang.String type;


	/**
	 *  The make, model or name of the source of radiation.
	 *  NSLS beamline X8C
	 *  Rigaku RU200
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 	protected java.lang.Float voltage;


	/**
	 *  The voltage in kilovolts at which the radiation source was
	 *  operated.
	 */
	public java.lang.Float getVoltage() 
	{
		return voltage;
	}
 
	public void setVoltage(java.lang.Float voltage)
	{
		this.voltage = voltage;
	}

 }
