package org.pdb.beans;

/**
 *  Data items in the DIFFRN_STANDARD_REFLN category record details
 *  about the reflections treated as standards during the measurement
 *  of a set of diffraction intensities.
 *  
 *  Note that these are the individual standard reflections, not the
 *  results of the analysis of the standard reflections.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_standard_reflnCategory>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>3</PDBx:index_h>
 *  <PDBx:index_k>2</PDBx:index_k>
 *  <PDBx:index_l>4</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>1</PDBx:index_h>
 *  <PDBx:index_k>9</PDBx:index_k>
 *  <PDBx:index_l>1</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  <PDBx:diffrn_standard_refln diffrn_id="s1" code="1">
 *  <PDBx:index_h>3</PDBx:index_h>
 *  <PDBx:index_k>0</PDBx:index_k>
 *  <PDBx:index_l>10</PDBx:index_l>
 *  </PDBx:diffrn_standard_refln>
 *  </PDBx:diffrn_standard_reflnCategory>
 * </pre>
 */
public class Diffrn_standard_refln 
{
		protected java.lang.String code;


	/**
	 *  The code identifying a reflection measured as a standard
	 *  reflection with the indices  attribute index_h,
	 *  in category diffrn_standard_refln  attribute index_k in category diffrn_standard_refln and
	 *  attribute index_l in category diffrn_standard_refln.  This is the same code as the
	 *  attribute standard_code in category diffrn_refln in the DIFFRN_REFLN list.
	 *  1
	 *  2
	 *  c1
	 *  c2
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of a standard reflection used in the diffraction
	 *  measurement process.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of a standard reflection used in the diffraction
	 *  measurement process.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of a standard reflection used in the diffraction
	 *  measurement process.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 }
