package org.pdb.beans;

/**
 *  Data items in the 3D_FITTING category
 *  record details of the method of fitting atomic
 *  coordinates from a PDB file into a 3d-em
 *  volume map file
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_fittingCategory>
 *  <PDBx:em_3d_fitting id="1" entry_id="1DYL">
 *  <PDBx:method>AUTOMATIC</PDBx:method>
 *  <PDBx:target_criteria>R-FACTOR</PDBx:target_criteria>
 *  <PDBx:software_name>1</PDBx:software_name>
 *  <PDBx:ref_space>REAL</PDBx:ref_space>
 *  <PDBx:ref_protocol>RIGID BODY REFINEMENT</PDBx:ref_protocol>
 *  <PDBx:details>   THE CRYSTAL STRUCTURE OF THE CAPSID
 *  PROTEIN FROM CHOI ET AL (1997) PROTEINS 3 27:345-359
 *  (SUBUNIT A OF PDB FILE 1VCQ) WAS PLACED INTO THE CRYO-EM
 *  DENSITY MAP. THE CAPSID PROTEIN WAS FIRST MANUALLY POSITIONED
 *  INTO THE CRYO-EM DENSITY CORRESPONDING TO POSITIONS OF THE
 *  FOUR INDEPENDENT MONOMER DENSITIES BETWEEN THE INNER LEAFLET
 *  OF THE BILAYER AND THE RNA. THESE POSITIONS WERE THEN REFINED
 *  BY RIGID BODY REFINEMENT IN REAL SPACE WITH THE PROGRAM EMFIT
 *  (CHENG ET AL. 1995, CELL 80, 621-630).  THE QUALITY OF THE FIT
 *  CAN BE SEEN FROM THE MAP DENSITY WITHIN THE PROTEIN. ALL 4563
 *  ATOMS ARE IN DENSITY OF AT LEAST 4 SIGMA (96.73) ABOVE THE
 *  AVERAGE (512.04), 1167 ATOMS ARE IN DENSITY BETWEEN 4 AND 5
 *  SIGMA, 3174 ATOMS ARE IN DENSITY BETWEEN 5 AND 6 SIGMA, AND 222
 *  ATOMS ARE IN DENSTY OF 6 SIGMA OR ABOVE. THE VARIATION IN
 *  DENSITY OVER THE FITTED PROTEIN CAN BE VISUALIZED WITH THE
 *  PSEUDO TEMPERATURE FACTOR. THE DENSITY VALUE AT EACH ATOM IS
 *  GIVEN IN THE 8TH COLUM (USUALLY THE OCCUPANCY) AS THE NUMBER
 *  OF STANDARD DEVIATION ABOVE BACKGROUND. COLUMN NINE (USUALLY
 *  THE TEMPERATURE FACTOR) CONTAINS THE VALUE OF THE RELATIVE
 *  DENSITY WITHIN THE FITTED PROTEIN SCALED LINEARLY SO THAT THE
 *  MINIMUM DENSITY IS 100.0 AND THE MAXIMUM DENSITY IS 1.0.  THE
 *  ATOMS THAT LIE IN THE LOWER DENSITY REGIONS WILL HAVE THE
 *  HIGHEST PSEUDO TEMPERATURE FACTORS.                                 </PDBx:details>
 *  </PDBx:em_3d_fitting>
 *  </PDBx:em_3d_fittingCategory>
 * </pre>
 */
public class Em_3d_fitting 
{
		protected java.lang.String details;


	/**
	 *  Any additional details regarding fitting of atomic
	 *  coordinates into the 3d-em volume.
	 *  partial
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to _entry_id in
	 *  the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_3d_fitting must uniquely identify
	 *  a fitting procedure of atomic coordinates
	 *  into 3dem reconstructed volume map.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String method;


	/**
	 *  The method used to fit atomic coordinates
	 *  into the 3dem reconstructed map.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Float overall_b_value;


	/**
	 *  The overall B (temperature factor) value for the 3d-em volume.
	 */
	public java.lang.Float getOverall_b_value() 
	{
		return overall_b_value;
	}
 
	public void setOverall_b_value(java.lang.Float overall_b_value)
	{
		this.overall_b_value = overall_b_value;
	}

 	protected java.lang.String ref_protocol;


	/**
	 *  The type of protocol used in the refinement.
	 *  rigid body
	 */
	public java.lang.String getRef_protocol() 
	{
		return ref_protocol;
	}
 
	public void setRef_protocol(java.lang.String ref_protocol)
	{
		this.ref_protocol = ref_protocol;
	}

 	protected java.lang.String ref_space;


	/**
	 *  A flag to indicate whether fitting was carried out in real
	 *  or reciprocal refinement space.
	 */
	public java.lang.String getRef_space() 
	{
		return ref_space;
	}
 
	public void setRef_space(java.lang.String ref_space)
	{
		this.ref_space = ref_space;
	}

 	protected java.lang.String software_name;


	/**
	 *  This data item is a pointer to  attribute name
	 *  in category software in the  category.
	 */
	public java.lang.String getSoftware_name() 
	{
		return software_name;
	}
 
	public void setSoftware_name(java.lang.String software_name)
	{
		this.software_name = software_name;
	}

 	protected java.lang.String target_criteria;


	/**
	 *  The quality of fit of the atomic coordinates into the
	 *  3dem volume map.
	 *  best visual fit using the program O
	 */
	public java.lang.String getTarget_criteria() 
	{
		return target_criteria;
	}
 
	public void setTarget_criteria(java.lang.String target_criteria)
	{
		this.target_criteria = target_criteria;
	}

 }
