package org.pdb.beans;

/**
 *  Data items in the 3D_FITTING_LIST category
 *  lists the methods of fitting atomic coordinates from a PDB file
 *  into a 3d-em volume map file
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_fitting_listCategory>
 *  <PDBx:em_3d_fitting_list id="1">
 *  <PDBx:pdb_entry_id>1VCQ</PDBx:pdb_entry_id>
 *  </PDBx:em_3d_fitting_list>
 *  </PDBx:em_3d_fitting_listCategory>
 * </pre>
 */
public class Em_3d_fitting_list 
{
		protected java.lang.String _3d_fitting_id;


	/**
	 *  The value of  attribute 3d_fitting_id in category em_3d_fitting_list is a pointer
	 *  to  attribute id in category em_3d_fitting in the 3d_fitting category
	 */
	public java.lang.String get_3d_fitting_id() 
	{
		return _3d_fitting_id;
	}
 
	public void set_3d_fitting_id(java.lang.String _3d_fitting_id)
	{
		this._3d_fitting_id = _3d_fitting_id;
	}

 	protected java.lang.String id_;


	/**
	 *  This data item is a unique identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdb_chain_id;


	/**
	 *  The chain id for the entry used in fitting.
	 */
	public java.lang.String getPdb_chain_id() 
	{
		return pdb_chain_id;
	}
 
	public void setPdb_chain_id(java.lang.String pdb_chain_id)
	{
		this.pdb_chain_id = pdb_chain_id;
	}

 	protected java.lang.String pdb_entry_id;


	/**
	 *  The PDB code for the entry used in fitting.
	 */
	public java.lang.String getPdb_entry_id() 
	{
		return pdb_entry_id;
	}
 
	public void setPdb_entry_id(java.lang.String pdb_entry_id)
	{
		this.pdb_entry_id = pdb_entry_id;
	}

 }
