package org.pdb.beans;

/**
 *  Data items in the EM_3D_RECONSTRUCTION category
 *  record details of the 3D reconstruction procedure from 2D projections.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_reconstructionCategory>
 *  <PDBx:em_3d_reconstruction entry_id="1DYL" id="1">
 *  <PDBx:method>CROSS-COMMON LINES</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:resolution>9.</PDBx:resolution>
 *  <PDBx:nominal_pixel_size>2.64</PDBx:nominal_pixel_size>
 *  <PDBx:actual_pixel_size>2.52</PDBx:actual_pixel_size>
 *  </PDBx:em_3d_reconstruction>
 *  </PDBx:em_3d_reconstructionCategory>
 * </pre>
 */
public class Em_3d_reconstruction 
{
		protected java.lang.Float actual_pixel_size;


	/**
	 *  The actual pixel size of projection set of images.
	 */
	public java.lang.Float getActual_pixel_size() 
	{
		return actual_pixel_size;
	}
 
	public void setActual_pixel_size(java.lang.Float actual_pixel_size)
	{
		this.actual_pixel_size = actual_pixel_size;
	}

 	protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the
	 *  CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String ctf_correction_method;


	/**
	 *  The  CTF-correction method.
	 *  The Contrast Transfer Function CTF compensation for low contrast
	 *  specimens (e.g. frozen-hydrated), for which phase contrast is the only
	 *  significant mechanism, then higher defocus levels must be used to
	 *  achieve any significant transfer, and several images at different
	 *  focus levels must be combined to complete the information lost from
	 *  the transfer gaps of any one image.  The CTF correction can be applied
	 *  to each extracted particle separately or to the whole micrograph after
	 *  digitisation. The simplest level of compensation is to reverse phases
	 *  at the negative lobes of the CTF.
	 *  CTF correction of each particle
	 */
	public java.lang.String getCtf_correction_method() 
	{
		return ctf_correction_method;
	}
 
	public void setCtf_correction_method(java.lang.String ctf_correction_method)
	{
		this.ctf_correction_method = ctf_correction_method;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional details used in the 3d reconstruction.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_3d_reconstruction must
	 *  uniquely identify the 3d reconstruction.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String magnification_calibration;


	/**
	 *  The  magnification calibration method for the 3d reconstruction.
	 */
	public java.lang.String getMagnification_calibration() 
	{
		return magnification_calibration;
	}
 
	public void setMagnification_calibration(java.lang.String magnification_calibration)
	{
		this.magnification_calibration = magnification_calibration;
	}

 	protected java.lang.String method;


	/**
	 *  The algorithm method used for the 3d-reconstruction.
	 *  cross-common lines
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Float nominal_pixel_size;


	/**
	 *  The nominal pixel size of the projection set of images.
	 */
	public java.lang.Float getNominal_pixel_size() 
	{
		return nominal_pixel_size;
	}
 
	public void setNominal_pixel_size(java.lang.Float nominal_pixel_size)
	{
		this.nominal_pixel_size = nominal_pixel_size;
	}

 	protected java.lang.Float resolution;


	/**
	 *  The final resolution (in angstroms)of the 3d reconstruction.
	 */
	public java.lang.Float getResolution() 
	{
		return resolution;
	}
 
	public void setResolution(java.lang.Float resolution)
	{
		this.resolution = resolution;
	}

 	protected java.lang.String resolution_method;


	/**
	 *  The  method used to determine the final resolution
	 *  of the 3d reconstruction.
	 *  The Fourier Shell Correlation criterion as a measure of
	 *  resolution is based on the concept of splitting the (2D)
	 *  data set into two halves; averaging each and comparing them
	 *  using the Fourier Ring Correlation (FRC) technique.
	 *  FSC at 0.5 cut-off
	 */
	public java.lang.String getResolution_method() 
	{
		return resolution_method;
	}
 
	public void setResolution_method(java.lang.String resolution_method)
	{
		this.resolution_method = resolution_method;
	}

 }
