package org.pdb.beans;

/**
 *  Data items in the EM_ASSEMBLY category record details
 *  about the type of complex assembly that describes the
 *  nature of the sample studied.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_assemblyCategory>
 *  <PDBx:em_assembly id="1" entry_id="1DYL">
 *  <PDBx:name>virus</PDBx:name>
 *  <PDBx:aggregation_state>icosahedral</PDBx:aggregation_state>
 *  <PDBx:composition>virus</PDBx:composition>
 *  <PDBx:num_components>1</PDBx:num_components>
 *  </PDBx:em_assembly>
 *  </PDBx:em_assemblyCategory>
 * </pre>
 */
public class Em_assembly 
{
		protected java.lang.String aggregation_state;


	/**
	 *  A description of the aggregation state of the assembly.
	 *  SINGLE PARTICLE
	 *  INDIVIDUAL STRUCTURE
	 *  2D-CRYSTAL
	 *  ICOSAHEDRAL
	 *  HELICAL
	 *  FILAMENT
	 *  HELICAL FILAMENTS
	 *  TISSUE
	 */
	public java.lang.String getAggregation_state() 
	{
		return aggregation_state;
	}
 
	public void setAggregation_state(java.lang.String aggregation_state)
	{
		this.aggregation_state = aggregation_state;
	}

 	protected java.lang.String composition;


	/**
	 *  The known composition of the assembly.
	 */
	public java.lang.String getComposition() 
	{
		return composition;
	}
 
	public void setComposition(java.lang.String composition)
	{
		this.composition = composition;
	}

 	protected java.lang.String details;


	/**
	 *  A description of any additional details
	 *  describing the observed sample.
	 *  This structure was preferentially oriented (end-on)on the grid.
	 *  The structure was monodisperse.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_assembly must uniquely identify
	 *  a collection of observed complexes.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float mol_wt_exp;


	/**
	 *  The value (in megadaltons) of the experimentally
	 *  determined molecular weight of the assembly.
	 */
	public java.lang.Float getMol_wt_exp() 
	{
		return mol_wt_exp;
	}
 
	public void setMol_wt_exp(java.lang.Float mol_wt_exp)
	{
		this.mol_wt_exp = mol_wt_exp;
	}

 	protected java.lang.String mol_wt_method;


	/**
	 *  The method used in determining
	 *  the molecular weight.
	 */
	public java.lang.String getMol_wt_method() 
	{
		return mol_wt_method;
	}
 
	public void setMol_wt_method(java.lang.String mol_wt_method)
	{
		this.mol_wt_method = mol_wt_method;
	}

 	protected java.lang.Float mol_wt_theo;


	/**
	 *  The value (in megadaltons) of the theoretically
	 *  determined molecular weight of the assembly.
	 */
	public java.lang.Float getMol_wt_theo() 
	{
		return mol_wt_theo;
	}
 
	public void setMol_wt_theo(java.lang.Float mol_wt_theo)
	{
		this.mol_wt_theo = mol_wt_theo;
	}

 	protected java.lang.String name;


	/**
	 *  The name of the assembly of observed complexes.
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.Integer num_components;


	/**
	 *  The number of components of the biological assembly.
	 */
	public java.lang.Integer getNum_components() 
	{
		return num_components;
	}
 
	public void setNum_components(java.lang.Integer num_components)
	{
		this.num_components = num_components;
	}

 }
