package org.pdb.beans;

/**
 *  Data items in the EM_DETECTOR category record details
 *  of the image detector type.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_detectorCategory>
 *  <PDBx:em_detector entry_id="1DYL" id="1">
 *  <PDBx:type>KODAK SO163 FILM</PDBx:type>
 *  </PDBx:em_detector>
 *  </PDBx:em_detectorCategory>
 * </pre>
 */
public class Em_detector 
{
		protected java.lang.String details;


	/**
	 *  Any additional information about the detection system.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Float detective_quantum_efficiency;


	/**
	 *  The detective_quantum_efficiency (DQE)is defined as the
	 *  square of the signal-to-noise ratio in the recording device
	 *  divided by the square of the signal-to-ratio in the electron beam:
	 *  (SIGNAL/NOISE)2 recording device
	 *  DQE =    -------------------------------
	 *  (SIGNAL/NOISE)2 electron beam
	 *  A DQE value of 1 indicates a perfect recorder. "DQE = 0.25" menas
	 *  that the signal-to-noise ratio is reduced by half in the
	 *  recording step.
	 *  (0.5)**2
	 *  DQE = --------- = 0.25.
	 *  (1.0)**2
	 *  0.25
	 */
	public java.lang.Float getDetective_quantum_efficiency() 
	{
		return detective_quantum_efficiency;
	}
 
	public void setDetective_quantum_efficiency(java.lang.Float detective_quantum_efficiency)
	{
		this.detective_quantum_efficiency = detective_quantum_efficiency;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_detector must uniquely identify
	 *  the detector used for imaging.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String type;


	/**
	 *  The detector type used for recording images.
	 *  Usually film or CCD camera.
	 *  KODAK SO163 FILM
	 *  GATAN 673
	 *  GATAN 676
	 *  GATAN 692
	 *  GATAN 794
	 *  GATAN 1000
	 *  GATAN 4000
	 *  TVIPS BIOCAM
	 *  TVIPS TEMCAM F214
	 *  TVIPS TEMCAM F224
	 *  TVIPS FASTSCAN F114
	 *  PROSCAN
	 *  AMT
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
