package org.pdb.beans;

/**
 *  data items in the em_electron_diffraction_pattern category
 *  record details about the pattern information
 *  from the electron diffraction experiment.
 * <pre>
 *  example 1 - based on pdb entry 1tub and laboratory records for the
 *  structure corresponding to pdb entry 1tub
 *  <PDBx:em_electron_diffraction_patternCategory>
 *  <PDBx:em_electron_diffraction_pattern entry_id="1TUB" id="1">
 *  <PDBx:num_patterns_by_tilt_angle>1</PDBx:num_patterns_by_tilt_angle>
 *  <PDBx:num_images_by_tilt_angle>4</PDBx:num_images_by_tilt_angle>
 *  </PDBx:em_electron_diffraction_pattern>
 *  </PDBx:em_electron_diffraction_patternCategory>
 * </pre>
 */
public class Em_electron_diffraction_pattern 
{
		protected java.lang.String entry_id;


	/**
	 *  this data item is a pointer to  attribute id in category entry in the entry category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  the value of  attribute id in category electron_diffraction_pattern must
	 *  uniquely identify the electron diffraction pattern experiment.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer num_images_by_tilt_angle;


	/**
	 *  the number of images by tilt angle.
	 *  4
	 */
	public java.lang.Integer getNum_images_by_tilt_angle() 
	{
		return num_images_by_tilt_angle;
	}
 
	public void setNum_images_by_tilt_angle(java.lang.Integer num_images_by_tilt_angle)
	{
		this.num_images_by_tilt_angle = num_images_by_tilt_angle;
	}

 	protected java.lang.Integer num_patterns_by_tilt_angle;


	/**
	 *  the number of diffraction patterns by tilt angle.
	 *  1
	 */
	public java.lang.Integer getNum_patterns_by_tilt_angle() 
	{
		return num_patterns_by_tilt_angle;
	}
 
	public void setNum_patterns_by_tilt_angle(java.lang.Integer num_patterns_by_tilt_angle)
	{
		this.num_patterns_by_tilt_angle = num_patterns_by_tilt_angle;
	}

 	protected java.lang.Integer tilt_angle;


	/**
	 *  the tilt angle at which the diffraction pattern was obtained.
	 */
	public java.lang.Integer getTilt_angle() 
	{
		return tilt_angle;
	}
 
	public void setTilt_angle(java.lang.Integer tilt_angle)
	{
		this.tilt_angle = tilt_angle;
	}

 }
