package org.pdb.beans;

/**
 *  data items in the em_electron_diffraction_phase category
 *  record details about the phase information
 *  from the electron diffraction experiment.
 * <pre>
 *  example 1 - based on pdb entry 1tub and laboratory records for the
 *  structure corresponding to pdb entry 1tub
 *  <PDBx:em_electron_diffraction_phaseCategory>
 *  <PDBx:em_electron_diffraction_phase entry_id="1TUB" id="1">
 *  <PDBx:d_res_high>4.0</PDBx:d_res_high>
 *  </PDBx:em_electron_diffraction_phase>
 *  </PDBx:em_electron_diffraction_phaseCategory>
 * </pre>
 */
public class Em_electron_diffraction_phase 
{
		protected java.lang.Integer d_res_high;


	/**
	 *  the highest resolution d-value for the electron diffraction experiment.
	 *  5.0
	 */
	public java.lang.Integer getD_res_high() 
	{
		return d_res_high;
	}
 
	public void setD_res_high(java.lang.Integer d_res_high)
	{
		this.d_res_high = d_res_high;
	}

 	protected java.lang.String entry_id;


	/**
	 *  this data item is a pointer to  attribute id in category entry in the entry category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer highest_resolution_shell_error;


	/**
	 *  the highest resolution shell error in degrees.
	 */
	public java.lang.Integer getHighest_resolution_shell_error() 
	{
		return highest_resolution_shell_error;
	}
 
	public void setHighest_resolution_shell_error(java.lang.Integer highest_resolution_shell_error)
	{
		this.highest_resolution_shell_error = highest_resolution_shell_error;
	}

 	protected java.lang.String id_;


	/**
	 *  the value of  attribute id in category electron_diffraction_phase must
	 *  uniquely identify the electron diffraction phase experiment.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer overall_error;


	/**
	 *  the overall phase error in degrees.
	 */
	public java.lang.Integer getOverall_error() 
	{
		return overall_error;
	}
 
	public void setOverall_error(java.lang.Integer overall_error)
	{
		this.overall_error = overall_error;
	}

 	protected java.lang.Integer rejection_criteria_error;


	/**
	 *  the rejection criteria (phase error) in degrees.
	 */
	public java.lang.Integer getRejection_criteria_error() 
	{
		return rejection_criteria_error;
	}
 
	public void setRejection_criteria_error(java.lang.Integer rejection_criteria_error)
	{
		this.rejection_criteria_error = rejection_criteria_error;
	}

 	protected java.lang.Integer residual;


	/**
	 *  the phase residual value for the electron diffraction experiment.
	 */
	public java.lang.Integer getResidual() 
	{
		return residual;
	}
 
	public void setResidual(java.lang.Integer residual)
	{
		this.residual = residual;
	}

 }
