package org.pdb.beans;

/**
 *  Data items in the EM_ENTITY_ASSEMBLY category
 *  record details about each component of
 *  the complex.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_entity_assemblyCategory>
 *  <PDBx:em_entity_assembly id="1" assembly_id="1">
 *  <PDBx:type>VIRUS</PDBx:type>
 *  </PDBx:em_entity_assembly>
 *  </PDBx:em_entity_assemblyCategory>
 * </pre>
 */
public class Em_entity_assembly 
{
		protected java.lang.String assembly_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_assembly in the
	 *  ASSEMBLY category.
	 */
	public java.lang.String getAssembly_id() 
	{
		return assembly_id;
	}
 
	public void setAssembly_id(java.lang.String assembly_id)
	{
		this.assembly_id = assembly_id;
	}

 	protected java.lang.String details;


	/**
	 *  Additional details about the component.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String ebi_cell;


	/**
	 *  The cell from which the component was
	 *  obtained.
	 *  CHO
	 *  HELA
	 *  3T3
	 */
	public java.lang.String getEbi_cell() 
	{
		return ebi_cell;
	}
 
	public void setEbi_cell(java.lang.String ebi_cell)
	{
		this.ebi_cell = ebi_cell;
	}

 	protected java.lang.String ebi_cellular_location;


	/**
	 *  The cellular location of the component.
	 *  cytoplasm
	 *  endoplasmic reticulum
	 *  plasma membrane
	 */
	public java.lang.String getEbi_cellular_location() 
	{
		return ebi_cellular_location;
	}
 
	public void setEbi_cellular_location(java.lang.String ebi_cellular_location)
	{
		this.ebi_cellular_location = ebi_cellular_location;
	}

 	protected java.lang.String ebi_engineered;


	/**
	 *  A flag to indicate whether the component is engineered.
	 */
	public java.lang.String getEbi_engineered() 
	{
		return ebi_engineered;
	}
 
	public void setEbi_engineered(java.lang.String ebi_engineered)
	{
		this.ebi_engineered = ebi_engineered;
	}

 	protected java.lang.String ebi_expression_system;


	/**
	 *  The expression system used to produce the component.
	 *  eschericia coli
	 *  saccharomyces cerevisiae
	 */
	public java.lang.String getEbi_expression_system() 
	{
		return ebi_expression_system;
	}
 
	public void setEbi_expression_system(java.lang.String ebi_expression_system)
	{
		this.ebi_expression_system = ebi_expression_system;
	}

 	protected java.lang.String ebi_expression_system_plasmid;


	/**
	 *  The plasmid used in the expression system used to produce the component.
	 *  pBR322
	 *  pMB9
	 */
	public java.lang.String getEbi_expression_system_plasmid() 
	{
		return ebi_expression_system_plasmid;
	}
 
	public void setEbi_expression_system_plasmid(java.lang.String ebi_expression_system_plasmid)
	{
		this.ebi_expression_system_plasmid = ebi_expression_system_plasmid;
	}

 	protected java.lang.String ebi_organelle;


	/**
	 *  The organelle from which the component was
	 *  obtained.
	 *  golgi
	 *  mitochondrion
	 *  cytoskeleton
	 */
	public java.lang.String getEbi_organelle() 
	{
		return ebi_organelle;
	}
 
	public void setEbi_organelle(java.lang.String ebi_organelle)
	{
		this.ebi_organelle = ebi_organelle;
	}

 	protected java.lang.String ebi_organism_common;


	/**
	 *  The common name of the species of the natural organism from which
	 *  the component was obtained.
	 */
	public java.lang.String getEbi_organism_common() 
	{
		return ebi_organism_common;
	}
 
	public void setEbi_organism_common(java.lang.String ebi_organism_common)
	{
		this.ebi_organism_common = ebi_organism_common;
	}

 	protected java.lang.String ebi_organism_scientific;


	/**
	 *  The species of the natural organism from which the component
	 *  was obtained.
	 */
	public java.lang.String getEbi_organism_scientific() 
	{
		return ebi_organism_scientific;
	}
 
	public void setEbi_organism_scientific(java.lang.String ebi_organism_scientific)
	{
		this.ebi_organism_scientific = ebi_organism_scientific;
	}

 	protected java.lang.String ebi_strain;


	/**
	 *  The strain of the natural organism from which the component was
	 *  obtained, if relevant.
	 *  DH5a
	 *  BMH 71-18
	 */
	public java.lang.String getEbi_strain() 
	{
		return ebi_strain;
	}
 
	public void setEbi_strain(java.lang.String ebi_strain)
	{
		this.ebi_strain = ebi_strain;
	}

 	protected java.lang.String ebi_tissue;


	/**
	 *  The tissue of the natural organism from which the component was
	 *  obtained.
	 *  heart
	 *  liver
	 *  eye lens
	 */
	public java.lang.String getEbi_tissue() 
	{
		return ebi_tissue;
	}
 
	public void setEbi_tissue(java.lang.String ebi_tissue)
	{
		this.ebi_tissue = ebi_tissue;
	}

 	protected java.lang.String go_id;


	/**
	 *  The Gene Ontology (GO) identifier for the component.
	 *  The GO id is the appropriate identifier used by the Gene Ontology
	 *  Consortium. Reference: Nature Genetics vol 25:25-29 (2000).
	 *  GO:0005876
	 *  GO:0015630
	 */
	public java.lang.String getGo_id() 
	{
		return go_id;
	}
 
	public void setGo_id(java.lang.String go_id)
	{
		this.go_id = go_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_entity_assembly must uniquely identify
	 *  each of the components of the complex.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String ipr_id;


	/**
	 *  The InterPro (IPR) identifier for the component.
	 *  The IPR id is the appropriate identifier used by the Interpro Resource.
	 *  Reference: Nucleic Acid Research vol 29(1):37-40(2001).
	 *  001304
	 *  002353
	 */
	public java.lang.String getIpr_id() 
	{
		return ipr_id;
	}
 
	public void setIpr_id(java.lang.String ipr_id)
	{
		this.ipr_id = ipr_id;
	}

 	protected java.lang.String name;


	/**
	 *  The name of the component of the observed assembly.
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String synonym;


	/**
	 *  Alternative name of the component.
	 *  FADV-1
	 */
	public java.lang.String getSynonym() 
	{
		return synonym;
	}
 
	public void setSynonym(java.lang.String synonym)
	{
		this.synonym = synonym;
	}

 	protected java.lang.String type;


	/**
	 *  A description of types of components of the
	 *  assembly of the biological structure.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
