package org.pdb.beans;

/**
 *  Data items in the EM_ICOS_VIRUS_SHELLS category record details
 *  of the viral shell number, diameter of each shell and triangulation number.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_icos_virus_shellsCategory>
 *  <PDBx:em_icos_virus_shells virus_entity_id="1" id="1">
 *  <PDBx:shell_diameter>400.</PDBx:shell_diameter>
 *  <PDBx:triangulation_num>4</PDBx:triangulation_num>
 *  </PDBx:em_icos_virus_shells>
 *  </PDBx:em_icos_virus_shellsCategory>
 * </pre>
 */
public class Em_icos_virus_shells 
{
		protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_em_icos_virus_shells must uniquely identify
	 *  the number and diameter of each virus protein shell and its
	 *  triangulation number.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float shell_diameter;


	/**
	 *  The value of the diameter (in angstroms) for each
	 *  protein shell of the virus.
	 */
	public java.lang.Float getShell_diameter() 
	{
		return shell_diameter;
	}
 
	public void setShell_diameter(java.lang.Float shell_diameter)
	{
		this.shell_diameter = shell_diameter;
	}

 	protected java.lang.Integer triangulation_num;


	/**
	 *  The triangulation number (T number) is a geometric and abstract
	 *  concept that does not correspond to the structural components of
	 *  an individul virus.
	 *  It refers to the organisation of the geometric figure.
	 *  The triangulation number, T is given by the following relationship:
	 *  T= h*2 + hk +k*2,  where h and k are positive integers which define the
	 *  position of the five-fold vertex on the original hexagonal net.
	 *  4
	 */
	public java.lang.Integer getTriangulation_num() 
	{
		return triangulation_num;
	}
 
	public void setTriangulation_num(java.lang.Integer triangulation_num)
	{
		this.triangulation_num = triangulation_num;
	}

 	protected java.lang.String virus_entity_id;


	/**
	 *  The value of  attribute virus_entity_id in category em_icos_virus_shells is
	 *  a pointer to  attribute id in category em_virus_entity in the VIRUS_ENTITY
	 *  category.
	 */
	public java.lang.String getVirus_entity_id() 
	{
		return virus_entity_id;
	}
 
	public void setVirus_entity_id(java.lang.String virus_entity_id)
	{
		this.virus_entity_id = virus_entity_id;
	}

 }
