package org.pdb.beans;

/**
 *  Data items in the EM_IMAGE_SCANS category record details
 *  of the image scanning device (microdensitometer)
 *  and parameters for digitization of the image.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_image_scansCategory>
 *  <PDBx:em_image_scans entry_id="1DYL" id="2">
 *  <PDBx:number_digital_images>48</PDBx:number_digital_images>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  </PDBx:em_image_scans>
 *  </PDBx:em_image_scansCategory>
 * </pre>
 */
public class Em_image_scans 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category citation in the CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional details about scanning images.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the
	 *  ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_image_scans must uniquely identify
	 *  the images scanned.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer number_digital_images;


	/**
	 *  The number of images scanned and digitised.
	 */
	public java.lang.Integer getNumber_digital_images() 
	{
		return number_digital_images;
	}
 
	public void setNumber_digital_images(java.lang.Integer number_digital_images)
	{
		this.number_digital_images = number_digital_images;
	}

 	protected java.lang.Float od_range;


	/**
	 *  The optical density range (OD=-log 10 transmission).
	 *  To the eye OD=1 appears light grey and OD=3 is opaque.
	 *  1.4
	 */
	public java.lang.Float getOd_range() 
	{
		return od_range;
	}
 
	public void setOd_range(java.lang.Float od_range)
	{
		this.od_range = od_range;
	}

 	protected java.lang.Integer quant_bit_size;


	/**
	 *  The number of bits per pixel.
	 *  8
	 */
	public java.lang.Integer getQuant_bit_size() 
	{
		return quant_bit_size;
	}
 
	public void setQuant_bit_size(java.lang.Integer quant_bit_size)
	{
		this.quant_bit_size = quant_bit_size;
	}

 	protected java.lang.Float sampling_size;


	/**
	 *  The sampling step size (microns) set on the scanner.
	 */
	public java.lang.Float getSampling_size() 
	{
		return sampling_size;
	}
 
	public void setSampling_size(java.lang.Float sampling_size)
	{
		this.sampling_size = sampling_size;
	}

 	protected java.lang.String scanner_model;


	/**
	 *  The scanner model.
	 */
	public java.lang.String getScanner_model() 
	{
		return scanner_model;
	}
 
	public void setScanner_model(java.lang.String scanner_model)
	{
		this.scanner_model = scanner_model;
	}

 }
