package org.pdb.beans;

/**
 *  Data items in the EM_SAMPLE_PREPARATION category
 *  record details of sample conditions prior to loading
 *  onto grid support.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_sample_preparationCategory>
 *  <PDBx:em_sample_preparation entry_id="1DYL" id="1">
 *  <PDBx:ph>7.6</PDBx:ph>
 *  <PDBx:buffer_id>1</PDBx:buffer_id>
 *  <PDBx:sample_concentration>5.</PDBx:sample_concentration>
 *  </PDBx:em_sample_preparation>
 *  </PDBx:em_sample_preparationCategory>
 * </pre>
 */
public class Em_sample_preparation 
{
		protected java.lang.String _2d_crystal_grow_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category em_2d_crystal_grow in the 2D_CRYSTAL_GROW category.
	 */
	public java.lang.String get_2d_crystal_grow_id() 
	{
		return _2d_crystal_grow_id;
	}
 
	public void set_2d_crystal_grow_id(java.lang.String _2d_crystal_grow_id)
	{
		this._2d_crystal_grow_id = _2d_crystal_grow_id;
	}

 	protected java.lang.String buffer_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_buffer in the
	 *  BUFFER category.
	 */
	public java.lang.String getBuffer_id() 
	{
		return buffer_id;
	}
 
	public void setBuffer_id(java.lang.String buffer_id)
	{
		this.buffer_id = buffer_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_sample_preparation must
	 *  uniquely identify the sample preparation.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float ph;


	/**
	 *  The pH value of the observed sample buffer.
	 */
	public java.lang.Float getPh() 
	{
		return ph;
	}
 
	public void setPh(java.lang.Float ph)
	{
		this.ph = ph;
	}

 	protected java.lang.Float sample_concentration;


	/**
	 *  The value of the concentration (mg/mL for mg per milliliter)
	 *  of the complex in the sample.
	 */
	public java.lang.Float getSample_concentration() 
	{
		return sample_concentration;
	}
 
	public void setSample_concentration(java.lang.Float sample_concentration)
	{
		this.sample_concentration = sample_concentration;
	}

 	protected java.lang.String support_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category em_sample_support in the EM_SAMPLE_SUPPORT category.
	 */
	public java.lang.String getSupport_id() 
	{
		return support_id;
	}
 
	public void setSupport_id(java.lang.String support_id)
	{
		this.support_id = support_id;
	}

 }
