package org.pdb.beans;

/**
 *  Data items in the EM_SAMPLE_SUPPORT category record details
 *  of the electron microscope grid type, grid support film and pretreatment
 *  of whole before sample is applied
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_sample_supportCategory>
 *  <PDBx:em_sample_support id="1">
 *  <PDBx:film_material>HOLEY CARBON</PDBx:film_material>
 *  <PDBx:grid_material>COPPER</PDBx:grid_material>
 *  <PDBx:grid_mesh_size>400</PDBx:grid_mesh_size>
 *  <PDBx:grid_type>MESH</PDBx:grid_type>
 *  <PDBx:pretreatment>GLOW DISCHARGE</PDBx:pretreatment>
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  </PDBx:em_sample_support>
 *  </PDBx:em_sample_supportCategory>
 * </pre>
 */
public class Em_sample_support 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category citation in the CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of any additional details concerning the sample support.
	 *  This grid plus sample was kept at -170 deg C for a month before use
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String film_material;


	/**
	 *  The support material covering the em grid.
	 */
	public java.lang.String getFilm_material() 
	{
		return film_material;
	}
 
	public void setFilm_material(java.lang.String film_material)
	{
		this.film_material = film_material;
	}

 	protected java.lang.String grid_material;


	/**
	 *  The name of the material from which the grid is made.
	 */
	public java.lang.String getGrid_material() 
	{
		return grid_material;
	}
 
	public void setGrid_material(java.lang.String grid_material)
	{
		this.grid_material = grid_material;
	}

 	protected java.lang.Integer grid_mesh_size;


	/**
	 *  The value of the mesh size (per inch) of the em grid.
	 *  400
	 */
	public java.lang.Integer getGrid_mesh_size() 
	{
		return grid_mesh_size;
	}
 
	public void setGrid_mesh_size(java.lang.Integer grid_mesh_size)
	{
		this.grid_mesh_size = grid_mesh_size;
	}

 	protected java.lang.String grid_type;


	/**
	 *  A description of the grid type.
	 */
	public java.lang.String getGrid_type() 
	{
		return grid_type;
	}
 
	public void setGrid_type(java.lang.String grid_type)
	{
		this.grid_type = grid_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_sample_support must uniquely identify
	 *  the sample support.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String method;


	/**
	 *  A description of the method used to produce the support film.
	 *  1%formvar in chloroform cast on distilled water
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String pretreatment;


	/**
	 *  A description of the grid plus support film pretreatment.
	 *  glow-discharged for 30 sec in argon
	 */
	public java.lang.String getPretreatment() 
	{
		return pretreatment;
	}
 
	public void setPretreatment(java.lang.String pretreatment)
	{
		this.pretreatment = pretreatment;
	}

 }
