package org.pdb.beans;

/**
 *  Data items in the ENTITY category record details (such as
 *  chemical composition, name and source) about the molecular
 *  entities that are present in the crystallographic structure.
 *  
 *  Items in the various ENTITY subcategories provide a full
 *  chemical description of these molecular entities.
 *  
 *  Entities are of three types:  polymer, non-polymer and water.
 *  Note that the water category includes only water;  ordered
 *  solvent such as sulfate ion or acetone would be described as
 *  individual non-polymer entities.
 *  
 *  The ENTITY category is specific to macromolecular CIF
 *  applications and replaces the function of the CHEMICAL category
 *  in the CIF core.
 *  
 *  It is important to remember that the ENTITY data are not the
 *  result of the crystallographic experiment;  those results are
 *  represented by the ATOM_SITE data items. ENTITY data items
 *  describe the chemistry of the molecules under investigation
 *  and can most usefully be thought of as the ideal groups to which
 *  the structure is restrained or constrained during refinement.
 *  
 *  It is also important to remember that entities do not correspond
 *  directly to the enumeration of the contents of the asymmetric
 *  unit. Entities are described only once, even in those structures
 *  that contain multiple observations of an entity. The
 *  STRUCT_ASYM data items, which reference the entity list,
 *  describe and label the contents of the asymmetric unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entityCategory>
 *  <PDBx:entity id="1">
 *  <PDBx:type>polymer</PDBx:type>
 *  <PDBx:formula_weight>10916.</PDBx:formula_weight>
 *  <PDBx:details>              The enzymatically competent form of HIV
 *  protease is a dimer. This entity
 *  corresponds to one monomer of an active dimer.</PDBx:details>
 *  </PDBx:entity>
 *  <PDBx:entity id="2">
 *  <PDBx:type>non-polymer</PDBx:type>
 *  <PDBx:formula_weight>762.</PDBx:formula_weight>
 *  </PDBx:entity>
 *  <PDBx:entity id="3">
 *  <PDBx:type>water</PDBx:type>
 *  <PDBx:formula_weight>18.</PDBx:formula_weight>
 *  </PDBx:entity>
 *  </PDBx:entityCategory>
 * </pre>
 */
public class Entity 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the entity.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Float formula_weight;


	/**
	 *  Formula mass in daltons of the entity.
	 */
	public java.lang.Float getFormula_weight() 
	{
		return formula_weight;
	}
 
	public void setFormula_weight(java.lang.Float formula_weight)
	{
		this.formula_weight = formula_weight;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category entity must uniquely identify a record in the
	 *  ENTITY list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String pdbx_description;


	/**
	 *  A description of the entity, with the name of the entity
	 *  in parenthesis.
	 *  
	 *  Maps to PDB compound name.
	 *  DNA (5'-D(*GP*(CH3)CP*GP*(CH3)CP*GP*C)-3')
	 *  PROFLAVINE
	 *  PROTEIN (DEOXYRIBONUCLEASE I (E.C.3.1.21.1))
	 */
	public java.lang.String getPdbx_description() 
	{
		return pdbx_description;
	}
 
	public void setPdbx_description(java.lang.String pdbx_description)
	{
		this.pdbx_description = pdbx_description;
	}

 	protected java.lang.String pdbx_ec;


	/**
	 *  Enzyme Commission (EC) number(s)
	 *  2.7.7.7
	 */
	public java.lang.String getPdbx_ec() 
	{
		return pdbx_ec;
	}
 
	public void setPdbx_ec(java.lang.String pdbx_ec)
	{
		this.pdbx_ec = pdbx_ec;
	}

 	protected java.lang.Float pdbx_formula_weight_exptl;


	/**
	 *  Experimentally determined formula mass in daltons of the entity
	 */
	public java.lang.Float getPdbx_formula_weight_exptl() 
	{
		return pdbx_formula_weight_exptl;
	}
 
	public void setPdbx_formula_weight_exptl(java.lang.Float pdbx_formula_weight_exptl)
	{
		this.pdbx_formula_weight_exptl = pdbx_formula_weight_exptl;
	}

 	protected java.lang.String pdbx_formula_weight_exptl_method;


	/**
	 *  Method used to determine  attribute pdbx_formula_weight_exptl in category entity.
	 *  MASS SPEC
	 */
	public java.lang.String getPdbx_formula_weight_exptl_method() 
	{
		return pdbx_formula_weight_exptl_method;
	}
 
	public void setPdbx_formula_weight_exptl_method(java.lang.String pdbx_formula_weight_exptl_method)
	{
		this.pdbx_formula_weight_exptl_method = pdbx_formula_weight_exptl_method;
	}

 	protected java.lang.String pdbx_fragment;


	/**
	 *  Entity fragment description(s).
	 *  KLENOW FRAGMENT
	 *  REPLICASE OPERATOR HAIRPIN
	 *  C-TERMINAL DOMAIN
	 */
	public java.lang.String getPdbx_fragment() 
	{
		return pdbx_fragment;
	}
 
	public void setPdbx_fragment(java.lang.String pdbx_fragment)
	{
		this.pdbx_fragment = pdbx_fragment;
	}

 	protected java.lang.String pdbx_modification;


	/**
	 *  Description(s) of any chemical or post-translational modifications
	 */
	public java.lang.String getPdbx_modification() 
	{
		return pdbx_modification;
	}
 
	public void setPdbx_modification(java.lang.String pdbx_modification)
	{
		this.pdbx_modification = pdbx_modification;
	}

 	protected java.lang.String pdbx_mutation;


	/**
	 *  Details about any entity mutation(s).
	 *  Y31H
	 *  DEL(298-323)
	 */
	public java.lang.String getPdbx_mutation() 
	{
		return pdbx_mutation;
	}
 
	public void setPdbx_mutation(java.lang.String pdbx_mutation)
	{
		this.pdbx_mutation = pdbx_mutation;
	}

 	protected java.lang.Float pdbx_number_of_molecules;


	/**
	 *  A place holder for the number of molecules of the entity in
	 *  the entry.
	 *  1.0
	 *  2.0
	 *  3.0
	 */
	public java.lang.Float getPdbx_number_of_molecules() 
	{
		return pdbx_number_of_molecules;
	}
 
	public void setPdbx_number_of_molecules(java.lang.Float pdbx_number_of_molecules)
	{
		this.pdbx_number_of_molecules = pdbx_number_of_molecules;
	}

 	protected java.lang.String pdbx_parent_entity_id;


	/**
	 *  An identifier for the parent entity if this entity
	 *  is part of a complex entity.  For instance a chimeric
	 *  entity may be decomposed into several independent
	 *  chemical entities where each component entity was
	 *  obtained from a different source.
	 *  1
	 *  2
	 *  3
	 */
	public java.lang.String getPdbx_parent_entity_id() 
	{
		return pdbx_parent_entity_id;
	}
 
	public void setPdbx_parent_entity_id(java.lang.String pdbx_parent_entity_id)
	{
		this.pdbx_parent_entity_id = pdbx_parent_entity_id;
	}

 	protected java.lang.String pdbx_target_id;


	/**
	 *  The value of  attribute target_id in category entity points to a TARGETDB target idenitifier
	 *  from which this entity was generated.
	 */
	public java.lang.String getPdbx_target_id() 
	{
		return pdbx_target_id;
	}
 
	public void setPdbx_target_id(java.lang.String pdbx_target_id)
	{
		this.pdbx_target_id = pdbx_target_id;
	}

 	protected java.lang.String src_method;


	/**
	 *  The method by which the sample for the entity was produced.
	 *  Entities isolated directly from natural sources (tissues, soil
	 *  samples etc.) are expected to have further information in the
	 *  ENTITY_SRC_NAT category. Entities isolated from genetically
	 *  manipulated sources are expected to have further information in
	 *  the ENTITY_SRC_GEN category.
	 */
	public java.lang.String getSrc_method() 
	{
		return src_method;
	}
 
	public void setSrc_method(java.lang.String src_method)
	{
		this.src_method = src_method;
	}

 	protected java.lang.String type;


	/**
	 *  Defines the type of the entity.
	 *  
	 *  Polymer entities are expected to have corresponding
	 *  ENTITY_POLY and associated entries.
	 *  
	 *  Non-polymer entities are expected to have corresponding
	 *  CHEM_COMP and associated entries.
	 *  
	 *  Water entities are not expected to have corresponding
	 *  entries in the ENTITY category.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
