package org.pdb.beans;

/**
 *  Data items in the ENTITY_KEYWORDS category specify keywords
 *  relevant to the molecular entities. Note that this list of
 *  keywords is separate from the list that is used for the
 *  STRUCT_BIOL data items and is intended to provide only the
 *  information that one would know about the molecular entity *if
 *  one did not know its structure*. Hence polypeptides are simply
 *  polypeptides, not cytokines or beta-alpha-barrels, and
 *  polyribonucleic acids are simply poly-RNA, not transfer-
 *  RNA.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_keywordsCategory>
 *  <PDBx:entity_keywords entity_id="2">
 *  <PDBx:text>natural product, inhibitor, reduced peptide</PDBx:text>
 *  </PDBx:entity_keywords>
 *  </PDBx:entity_keywordsCategory>
 * </pre>
 */
public class Entity_keywords 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String pdbx_ec;


	/**
	 *  Enzyme Commission (EC) number(s)
	 *  2.7.7.7
	 */
	public java.lang.String getPdbx_ec() 
	{
		return pdbx_ec;
	}
 
	public void setPdbx_ec(java.lang.String pdbx_ec)
	{
		this.pdbx_ec = pdbx_ec;
	}

 	protected java.lang.String pdbx_fragment;


	/**
	 *  Entity fragment description(s).
	 *  KLENOW FRAGMENT
	 *  REPLICASE OPERATOR HAIRPIN
	 *  C-TERMINAL DOMAIN
	 */
	public java.lang.String getPdbx_fragment() 
	{
		return pdbx_fragment;
	}
 
	public void setPdbx_fragment(java.lang.String pdbx_fragment)
	{
		this.pdbx_fragment = pdbx_fragment;
	}

 	protected java.lang.String pdbx_mutation;


	/**
	 *  Entity mutation description(s).
	 *  Y31H
	 *  DEL(298-323)
	 */
	public java.lang.String getPdbx_mutation() 
	{
		return pdbx_mutation;
	}
 
	public void setPdbx_mutation(java.lang.String pdbx_mutation)
	{
		this.pdbx_mutation = pdbx_mutation;
	}

 	protected java.lang.String text;


	/**
	 *  Keywords describing this entity.
	 *  polypeptide
	 *  natural product
	 *  polysaccharide
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
